//
//  PPTextView.h
//  
//
//  Created by Mike on 13/5/7.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPTextViewDefaultGap   10

typedef NS_ENUM (NSUInteger, PPTextViewPlaceholderStyle)
{
    PPTextViewPlaceholderStyle_Top = 0,
    PPTextViewPlaceholderStyle_Center,
    PPTextViewPlaceholderStyle_Bottom,
};
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPTextView : UITextView 
{
@private
    UILabel     *placeHolderLabel_;
    NSString    *placeholder_;
    BOOL        menuEnabled_;
    BOOL        selectionEnabled_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,readonly) UILabel *placeHolderLabel;
@property(nonatomic,retain) NSString *placeholder;
@property(nonatomic,assign) BOOL     menuEnabled;
@property(nonatomic,assign) BOOL     selectionEnabled;

@property(nonatomic,assign) PPTextViewPlaceholderStyle     placeholderStyle;

@end
