//
//  PPSectionController.h
//  
//
//  Created by Mike on 13/5/29.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPSectionHeaderView.h"
#import "PPSectionModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPSectionNULL  (-1)

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSectionController : NSObject 

#pragma mark - Property

@property(nonatomic, readonly) NSMutableArray  *sectionModelsForDefault;
@property(nonatomic, readonly) NSMutableArray  *sectionModelsForSearching;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (NSMutableArray *)sectionModelsForSearching:(BOOL)searching;
- (NSInteger)numberOfSectionsForSearching:(BOOL)searching;
- (NSInteger)sectionForSectionIndexTitle:(NSString *)title forSearching:(BOOL)searching;
- (NSString *)titleForHeaderInSection:(NSInteger)section forSearching:(BOOL)searching;
- (PPSectionHeaderView *)viewForHeaderInSection:(NSInteger)section forSearching:(BOOL)searching;
- (NSInteger)numberOfRowsInSection:(NSInteger)section forSearching:(BOOL)searching;
- (NSUInteger)rowObjectsCountForSearching:(BOOL)searching;
- (PPRowModel *)rowModelAtIndex:(NSUInteger)index forSearching:(BOOL)searching;
- (PPRowModel *)rowModelAtIndexPath:(NSIndexPath *)indexPath forSearching:(BOOL)searching;
- (NSIndexPath *)indexPathForRowModel:(PPRowModel *)rowModel forSearching:(BOOL)searching;

// for async use
- (void)replaceSectionModels:(NSArray *)sectionModels forSearching:(BOOL)searching;
- (PPRowModel *)copyRowModelAtIndexPath:(NSIndexPath *)indexPath forSearching:(BOOL)searching;

@end
