//
//  PPLogControllerExtension.h
//
//  Created by Egg on 2014/10/3.
//  Copyright (c) 2014年 com.penpower. All rights reserved.
//

#ifndef PPLogControllerExtension_h
#define PPLogControllerExtension_h

#import "PPLogController.h"

typedef NS_OPTIONS(NSUInteger, PPLogControllerMask_CustomType)
{
    PPLogControllerMask_CustomType_FunctionInOut  = PPLogControllerMask_Custom<<0,
    PPLogControllerMask_CustomType_ViewEventInOut = PPLogControllerMask_Custom<<1,
    PPLogControllerMask_CustomType_ViewEvent      = PPLogControllerMask_Custom<<2,
    PPLogControllerMask_CustomType_FunctionInfo   = PPLogControllerMask_Custom<<3,
    PPLogControllerMask_CustomType_BLESDKInfo     = PPLogControllerMask_Custom<<4,
    PPLogControllerMask_CustomType_BLESDKWarn     = PPLogControllerMask_Custom<<5,
    PPLogControllerMask_CustomType_Error          = PPLogControllerMask_Custom<<6,
    PPLogControllerMask_CustomType_Warning        = PPLogControllerMask_Custom<<7,
    PPLogControllerMask_CustomType_DelegateInOut  = PPLogControllerMask_Custom<<8,
};

//#define XCODE_COLORS_ESCAPE @"\033["
//#define XCODE_COLORS_FG_Gray XCODE_COLORS_ESCAPE @"fg128,128,128;"
//#define XCODE_COLORS_FG_Yellow XCODE_COLORS_ESCAPE @"fg255,204,51;"
//#define XCODE_COLORS_FG_Pink XCODE_COLORS_ESCAPE @"fg255,58,159;"
//#define XCODE_COLORS_FG_Green XCODE_COLORS_ESCAPE @"fg0,255,0;"
//#define XCODE_COLORS_BG_Red   XCODE_COLORS_ESCAPE @"bg255,0,0;"

//#define XCODE_COLORS_RESET_FG  XCODE_COLORS_ESCAPE @"fg;" // Clear any foreground color
//#define XCODE_COLORS_RESET_BG  XCODE_COLORS_ESCAPE @"bg;" // Clear any background color
//#define XCODE_COLORS_RESET     XCODE_COLORS_ESCAPE @";"   // Clear any foreground or background color

#define PPLogFuncIn(va_args, ...) PPLog(PPLogControllerMask_CustomType_FunctionInOut, (@"╔═<%s> "  @"start" va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogFuncOut(va_args, ...) PPLog(PPLogControllerMask_CustomType_FunctionInOut, (@"╚═<%s> "  @"finished" va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogDelegateIn(va_args, ...) PPLog(PPLogControllerMask_CustomType_DelegateInOut, (@"╔═<%s> "  @"start" va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogDelegateOut(va_args, ...) PPLog(PPLogControllerMask_CustomType_DelegateInOut, (@"╚═<%s> "  @"finished" va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogViewEventIn(va_args, ...) PPLog(PPLogControllerMask_CustomType_ViewEventInOut, (@"╔═<%s> "  @"start" va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogViewEventOut(va_args, ...) PPLog(PPLogControllerMask_CustomType_ViewEventInOut, (@"╚═<%s> "  @"finished" va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogViewEvent(va_args, ...) PPLog(PPLogControllerMask_CustomType_ViewEvent, (@"║ " va_args), ##__VA_ARGS__)

#define PPLogFuncInfo(va_args, ...) PPLog(PPLogControllerMask_CustomType_FunctionInfo, (@"╠═<%s> " va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__ )

#define PPLogBLESDKInfo(va_args, ...) PPLog(PPLogControllerMask_CustomType_BLESDKInfo, (@"╠═<%s> " va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogBLESDKWarn(va_args, ...) PPLog(PPLogControllerMask_CustomType_BLESDKWarn, (@"╠═<%s> " va_args ), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#define PPLogNormal(va_args, ...) PPLog(PPLogControllerMask_Normal, (@"║ " va_args), ##__VA_ARGS__)

#define PPLogError(va_args, ...) PPLog(PPLogControllerMask_CustomType_Error, (@"║ " va_args), ##__VA_ARGS__)

#define PPLogWarn(va_args, ...) PPLog(PPLogControllerMask_CustomType_Warning, (@"╠═<%s> " va_args), __PRETTY_FUNCTION__, ##__VA_ARGS__)

#endif
