//
//  PPGuideController.h
//
//  Created by eddie on 2015/4/3.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "PPGuideDataModel.h"
#import "PPGuideFocusModel.h"
#import "UIView+PPGuideController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPGuideControllerDelegate <NSObject>

@optional

/// confirm button按下通知
- (void)guideControllerDidClickConfirmButton:(UIButton *)confirmButton;

/// script結束通知
- (void)guideControllerDidFinishScript:(NSString *)guideScriptName;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGuideController : NSObject


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods : Common use

/**
 * Set delegate
 *
 * @param delegate - Instance to reveive delegate
 */
+ (void)setDelegate:(id<PPGuideControllerDelegate>)delegate;

/**
 * 設定共用屬性
 * canTouchThrough設定為YES時，confirmButton會無法設定。
 *
 * @param maskColor - 遮罩顏色
 * @param useBlurBackground - 遮罩是否使用模糊背景
 * @param guideFocus - 焦點區域樣式資料
 * @param titleFont - title字型
 * @param titleColor - title顏色
 * @param messageFont - message字型
 * @param messageColor - message顏色
 * @param confirmButton - confirm按鈕
 */
+ (void)setAttributeWithMaskColor:(UIColor *)maskColor
                useBlurBackground:(BOOL)useBlurBackground
                       guideFocus:(PPGuideFocusModel *)guideFocus
                        titleFont:(UIFont *)titleFont
                      titleCollor:(UIColor *)titleColor
                      messageFont:(UIFont *)messageFont
                     messageColor:(UIColor *)messageColor
                    confirmButton:(UIButton *)confirmButton;

/**
 * 加入需要顯示guide的物件資訊
 * 目前只能支援一般的UIView及使用CustomView的UIBarButtonItem，
 *
 * @param guideScriptName - Script name of guide.
 * @param guideDataModels - Array of PPGuideDataModel.
 */
+ (void)addGuideScriptWithName:(NSString *)guideScriptName
               guideDataModels:(NSArray *)guideDataModels;

/**
 * 清除所有guide的物件資訊
 */
+ (void)clearAllGuideScripts;

/**
 * Guide是否正在顯示
 *
 * @return YES表示正在顯示
 */
+ (BOOL)isGuideDisplaying;

/**
 * 強制結束目前的guide
 */
+ (void)finishCurrentGuideScript;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods : Guide-In-ViewController

/**
 * 自動偵測並顯示guide，請在viewWillAppear一開始呼叫。
 *
 * @param viewController - UIViewController that contains view need to display guide
 */
+ (void)monitorSignalWithViewController:(UIViewController *)viewController;

/**
 * 在ViewController中手動顯示guide
 *
 * @param viewController - View controller.
 */
+ (void)manuallyShowGuideWithViewController:(UIViewController *)viewController;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods : Guide-In-View

/**
 * 在View中手動顯示guide
 *
 * @param view - 要顯示guide的view。注意view.ppGuideClassName的名稱必須先指定。（和要顯示的PPGuideDataModel.className相同）
 */
+ (void)manuallyShowGuideWithView:(UIView *)view;



@end
