//
//  PPFloatingMenuItemView.h
//
//  Created by eddie on 2015/6/4.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, PPFloatingMenuItemView_LayoutStyle)
{
    PPFloatingMenuItemView_LayoutStyle_IconText = 0,    // Icon in left side, text in right side.
    PPFloatingMenuItemView_LayoutStyle_TextIcon,        // Text in left side, icon in right side.
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPFloatingMenuItemViewDelegate <NSObject>

@optional
/**
 * Delegate when item was tapped
 *
 * @param view - PPFloatingMenuItemView instance
 * @param identifier - Item identifier.
 */
- (void)floatingMenuItemView:(id)view didTapItemWithIdentifier:(NSInteger)identifier;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPFloatingMenuItemView : UIView


/**
 * Text font of menu item.
 */
@property (nonatomic, retain) UIFont *menuItemTextFont;


/**
 * Text color of menu item.
 */
@property (nonatomic, retain) UIColor *menuItemTextColor;


/**
 * Text background color of menu item.
 */
@property (nonatomic, retain) UIColor *menuItemTextBackgroundColor;


/**
 * Icon size of menu item.
 */
@property (nonatomic, assign) CGSize menuItemIconSize;


/**
 * initialize
 *
 * @param identifier - Unique identifier for item
 * @param icon - Item icon image
 * @param text - Item text string
 * @param delegate - Instance apply PPFloatingMenuItemViewDelegate
 * @return PPFloatingMenuItemView instance
 */
- (id)initWithIdentifier:(NSInteger)identifier
                    icon:(UIImage *)icon
                    text:(NSString *)text
                delegate:(id<PPFloatingMenuItemViewDelegate>) delegate;


/**
 * Setup layout style
 *
 * @param style - PPFloatingMenuItemView_LayoutStyle
 */
- (void)setLayoutStyle:(PPFloatingMenuItemView_LayoutStyle)style;


/**
 * Get estimated view size
 *
 * @return view size
 */
- (CGSize)estimatedViewSize;


/**
 * Get estimated icon frame
 *
 * @return icon frame
 */
- (CGRect)estimatedIconFrame;

@end
