//
//  PPBusyView.h
//
//  Created by Mike on 13/5/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPAutoResizedLabel.h"
#import "PPAppearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPBusyViewDefaultAlpha                  0.7f
#define PPBusyViewDefaultBorderCornerRadius    10.0f
#define PPBusyViewDefaultBorderMargin          25.0f
#define PPBuysViewDefaultBorderPadding         15.0f
#define PPBusyViewDefaultGap                   10.0f
#define PPBusyViewDefaultMessageHeight         20.0f
#define PPBusyViewDefaultMessageMaxRow         2

////////////////////////////////////////////////////////////////////////////////////////////////////

extern NSString *PPBusyViewNotification_Message;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPBusyViewStyle)
{
    PPBusyViewStyle_FillView = 0,
    PPBusyViewStyle_Border
};





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPBusyView()

@interface PPBusyView : UIView <PPAppearance>





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)     CGFloat                   centerY;
@property(nonatomic,assign)     CGRect                    borderFrame;
@property(nonatomic,readonly)   UIActivityIndicatorView   *activityIndicatorView;
@property(nonatomic,readonly)   PPAutoResizedLabel        *messageLabel;
@property(nonatomic,assign)     PPBusyViewStyle           style PP_APPEARANCE_SELECTOR;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Init & Delloc

/**
 *  Init with some UIView and add to it as its subView
 *
 *  @param superView the view it will be added to
 *
 *  @return instance
 */
- (id)initWithSuperView:(UIView *)superView;


/**
 *  不秀訊息的BusyView
 *
 *  @param superView   busyView 要 added 的 view
 *  @param showMessage YES,　秀訊息， NO, 不秀訊息
 *
 *  @return instance
 */
- (id)initWithSuperView:(UIView *)superView showMessage:(BOOL)showMessage;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

/**
 *  Post message on all existing BusyView
 *
 *  @param message message to present on busyView
 */
+ (void)postMessage:(NSString *)message;

@end
