//
//  PPAppearance.h
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

/// appearance標籤
#define PP_APPEARANCE_SELECTOR UI_APPEARANCE_SELECTOR

////////////////////////////////////////////////////////////////////////////////////////////////////

/// PPAppearance prorocol
@protocol PPAppearance <NSObject>

/**
 * 支援PPAppearance必須實作的函式
 *
 * @return PPAppearance instance
 */
+ (id)appearance;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

/// PPAppearance interface
@interface PPAppearance : NSObject

/**
 * 取得class關聯的appearance，實作+appearance時使用。
 *
 * @param aClass Class that need to get appearance instance
 * @return PPAppearance instance
 */
+ (id)appearanceForClass:(Class)aClass;


/**
 * 套用appearance的設定
 *
 * @param target 要套用appearance的instance
 */
- (void)applyInvocationTo:(id)target;

@end
