//
//  AlbumContentNavigationBarView.h
//
//  Created by Howard on 13/6/5.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <PPButton.h>

// Define
#import "PPAlbumContentViewController+ParameterDefine.h"

// View
#import "PPNavigationBarView.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumContentNavigationBarViewDelegate

@class AlbumContentNavigationBarView;

@protocol AlbumContentNavigationBarViewDelegate <NSObject>

@required

-(void)albumContentNavigationBarView:(AlbumContentNavigationBarView *)albumContentNavigationBarView didClickButton:(PPButton *)button withControlEvent:(UIControlEvents)event;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumContentNavigationBarView

@interface AlbumContentNavigationBarView : PPNavigationBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<AlbumContentNavigationBarViewDelegate> delegate;
@property (nonatomic,readonly) PPButton *backButton;
@property (nonatomic,readonly) PPButton *doneButton;
@property (nonatomic,retain) PPButton *allSelectButton;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)updateCaptureCountLabelWithCount:(NSInteger)count;

@end
