///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMTeamFolderInvalidStatusError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamFolderInvalidStatusError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamFolderInvalidStatusError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMTeamFolderInvalidStatusErrorTag` enum type represents the
/// possible tag states with which the `DBTEAMTeamFolderInvalidStatusError`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMTeamFolderInvalidStatusErrorTag){
    /// The folder is active and the operation did not succeed.
    DBTEAMTeamFolderInvalidStatusErrorActive,

    /// The folder is archived and the operation did not succeed.
    DBTEAMTeamFolderInvalidStatusErrorArchived,

    /// The folder is being archived and the operation did not succeed.
    DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress,

    /// (no description).
    DBTEAMTeamFolderInvalidStatusErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMTeamFolderInvalidStatusErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "active".
///
/// Description of the "active" tag state: The folder is active and the
/// operation did not succeed.
///
/// @return An initialized instance.
///
- (instancetype)initWithActive;

///
/// Initializes union class with tag state of "archived".
///
/// Description of the "archived" tag state: The folder is archived and the
/// operation did not succeed.
///
/// @return An initialized instance.
///
- (instancetype)initWithArchived;

///
/// Initializes union class with tag state of "archive_in_progress".
///
/// Description of the "archive_in_progress" tag state: The folder is being
/// archived and the operation did not succeed.
///
/// @return An initialized instance.
///
- (instancetype)initWithArchiveInProgress;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "active".
///
/// @return Whether the union's current tag state has value "active".
///
- (BOOL)isActive;

///
/// Retrieves whether the union's current tag state has value "archived".
///
/// @return Whether the union's current tag state has value "archived".
///
- (BOOL)isArchived;

///
/// Retrieves whether the union's current tag state has value
/// "archive_in_progress".
///
/// @return Whether the union's current tag state has value
/// "archive_in_progress".
///
- (BOOL)isArchiveInProgress;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMTeamFolderInvalidStatusError` union.
///
@interface DBTEAMTeamFolderInvalidStatusErrorSerializer : NSObject

///
/// Serializes `DBTEAMTeamFolderInvalidStatusError` instances.
///
/// @param instance An instance of the `DBTEAMTeamFolderInvalidStatusError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderInvalidStatusError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderInvalidStatusError *)instance;

///
/// Deserializes `DBTEAMTeamFolderInvalidStatusError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderInvalidStatusError` API object.
///
/// @return An instantiation of the `DBTEAMTeamFolderInvalidStatusError` object.
///
+ (DBTEAMTeamFolderInvalidStatusError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
