///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSharedLinkAccessLevel;
@class DBTEAMLOGSharedLinkCreateDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedLinkCreateDetails` struct.
///
/// Created shared link.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedLinkCreateDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Defines who can access the shared link. Might be missing due to historical
/// data gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGSharedLinkAccessLevel *sharedLinkAccessLevel;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharedLinkAccessLevel Defines who can access the shared link. Might
/// be missing due to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkAccessLevel:(nullable DBTEAMLOGSharedLinkAccessLevel *)sharedLinkAccessLevel;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedLinkCreateDetails` struct.
///
@interface DBTEAMLOGSharedLinkCreateDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedLinkCreateDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGSharedLinkCreateDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedLinkCreateDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSharedLinkCreateDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedLinkCreateDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedLinkCreateDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSharedLinkCreateDetails` object.
///
+ (DBTEAMLOGSharedLinkCreateDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
