///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSendForSignaturePolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SendForSignaturePolicy` union.
///
/// Policy for controlling team access to send for signature feature
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSendForSignaturePolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGSendForSignaturePolicyTag` enum type represents the possible
/// tag states with which the `DBTEAMLOGSendForSignaturePolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGSendForSignaturePolicyTag){
    /// (no description).
    DBTEAMLOGSendForSignaturePolicyDisabled,

    /// (no description).
    DBTEAMLOGSendForSignaturePolicyEnabled,

    /// (no description).
    DBTEAMLOGSendForSignaturePolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGSendForSignaturePolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "enabled".
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGSendForSignaturePolicy` union.
///
@interface DBTEAMLOGSendForSignaturePolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGSendForSignaturePolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGSendForSignaturePolicy` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSendForSignaturePolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSendForSignaturePolicy *)instance;

///
/// Deserializes `DBTEAMLOGSendForSignaturePolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSendForSignaturePolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGSendForSignaturePolicy` object.
///
+ (DBTEAMLOGSendForSignaturePolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
