///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperDocChangeSharingPolicyDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDocChangeSharingPolicyDetails` struct.
///
/// Changed sharing setting for Paper doc.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperDocChangeSharingPolicyDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Event unique identifier.
@property (nonatomic, readonly, copy) NSString *eventUuid;

/// Sharing policy with external users.
@property (nonatomic, readonly, copy, nullable) NSString *publicSharingPolicy;

/// Sharing policy with team.
@property (nonatomic, readonly, copy, nullable) NSString *teamSharingPolicy;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param eventUuid Event unique identifier.
/// @param publicSharingPolicy Sharing policy with external users.
/// @param teamSharingPolicy Sharing policy with team.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid
              publicSharingPolicy:(nullable NSString *)publicSharingPolicy
                teamSharingPolicy:(nullable NSString *)teamSharingPolicy;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param eventUuid Event unique identifier.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperDocChangeSharingPolicyDetails` struct.
///
@interface DBTEAMLOGPaperDocChangeSharingPolicyDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperDocChangeSharingPolicyDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGPaperDocChangeSharingPolicyDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDocChangeSharingPolicyDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperDocChangeSharingPolicyDetails *)instance;

///
/// Deserializes `DBTEAMLOGPaperDocChangeSharingPolicyDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDocChangeSharingPolicyDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGPaperDocChangeSharingPolicyDetails` object.
///
+ (DBTEAMLOGPaperDocChangeSharingPolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
