///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGovernancePolicyEditDetailsDetails;
@class DBTEAMLOGPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GovernancePolicyEditDetailsDetails` struct.
///
/// Edited policy.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGovernancePolicyEditDetailsDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Policy ID.
@property (nonatomic, readonly, copy) NSString *governancePolicyId;

/// Policy name.
@property (nonatomic, readonly, copy) NSString *name;

/// Policy type.
@property (nonatomic, readonly, nullable) DBTEAMLOGPolicyType *policyType;

/// Attribute.
@property (nonatomic, readonly, copy) NSString *attribute;

/// From.
@property (nonatomic, readonly, copy) NSString *previousValue;

/// To.
@property (nonatomic, readonly, copy) NSString *dNewValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param attribute Attribute.
/// @param previousValue From.
/// @param dNewValue To.
/// @param policyType Policy type.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                 attribute:(NSString *)attribute
                             previousValue:(NSString *)previousValue
                                 dNewValue:(NSString *)dNewValue
                                policyType:(nullable DBTEAMLOGPolicyType *)policyType;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param attribute Attribute.
/// @param previousValue From.
/// @param dNewValue To.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                 attribute:(NSString *)attribute
                             previousValue:(NSString *)previousValue
                                 dNewValue:(NSString *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GovernancePolicyEditDetailsDetails` struct.
///
@interface DBTEAMLOGGovernancePolicyEditDetailsDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGovernancePolicyEditDetailsDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGovernancePolicyEditDetailsDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyEditDetailsDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGovernancePolicyEditDetailsDetails *)instance;

///
/// Deserializes `DBTEAMLOGGovernancePolicyEditDetailsDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyEditDetailsDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGovernancePolicyEditDetailsDetails` object.
///
+ (DBTEAMLOGGovernancePolicyEditDetailsDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
