///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAccountState;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AccountState` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAccountState : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAccountStateTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGAccountState` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAccountStateTag){
    /// (no description).
    DBTEAMLOGAccountStateLocked,

    /// (no description).
    DBTEAMLOGAccountStateUnlocked,

    /// (no description).
    DBTEAMLOGAccountStateOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAccountStateTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "locked".
///
/// @return An initialized instance.
///
- (instancetype)initWithLocked;

///
/// Initializes union class with tag state of "unlocked".
///
/// @return An initialized instance.
///
- (instancetype)initWithUnlocked;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "locked".
///
/// @return Whether the union's current tag state has value "locked".
///
- (BOOL)isLocked;

///
/// Retrieves whether the union's current tag state has value "unlocked".
///
/// @return Whether the union's current tag state has value "unlocked".
///
- (BOOL)isUnlocked;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAccountState` union.
///
@interface DBTEAMLOGAccountStateSerializer : NSObject

///
/// Serializes `DBTEAMLOGAccountState` instances.
///
/// @param instance An instance of the `DBTEAMLOGAccountState` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAccountState` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountState *)instance;

///
/// Deserializes `DBTEAMLOGAccountState` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAccountState` API object.
///
/// @return An instantiation of the `DBTEAMLOGAccountState` object.
///
+ (DBTEAMLOGAccountState *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
