///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMFeature;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `Feature` union.
///
/// A set of features that a Dropbox Business account may support.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMFeature : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMFeatureTag` enum type represents the possible tag states with
/// which the `DBTEAMFeature` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMFeatureTag){
    /// The number of upload API calls allowed per month.
    DBTEAMFeatureUploadApiRateLimit,

    /// Does this team have a shared team root.
    DBTEAMFeatureHasTeamSharedDropbox,

    /// Does this team have file events.
    DBTEAMFeatureHasTeamFileEvents,

    /// Does this team have team selective sync enabled.
    DBTEAMFeatureHasTeamSelectiveSync,

    /// (no description).
    DBTEAMFeatureOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMFeatureTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "upload_api_rate_limit".
///
/// Description of the "upload_api_rate_limit" tag state: The number of upload
/// API calls allowed per month.
///
/// @return An initialized instance.
///
- (instancetype)initWithUploadApiRateLimit;

///
/// Initializes union class with tag state of "has_team_shared_dropbox".
///
/// Description of the "has_team_shared_dropbox" tag state: Does this team have
/// a shared team root.
///
/// @return An initialized instance.
///
- (instancetype)initWithHasTeamSharedDropbox;

///
/// Initializes union class with tag state of "has_team_file_events".
///
/// Description of the "has_team_file_events" tag state: Does this team have
/// file events.
///
/// @return An initialized instance.
///
- (instancetype)initWithHasTeamFileEvents;

///
/// Initializes union class with tag state of "has_team_selective_sync".
///
/// Description of the "has_team_selective_sync" tag state: Does this team have
/// team selective sync enabled.
///
/// @return An initialized instance.
///
- (instancetype)initWithHasTeamSelectiveSync;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "upload_api_rate_limit".
///
/// @return Whether the union's current tag state has value
/// "upload_api_rate_limit".
///
- (BOOL)isUploadApiRateLimit;

///
/// Retrieves whether the union's current tag state has value
/// "has_team_shared_dropbox".
///
/// @return Whether the union's current tag state has value
/// "has_team_shared_dropbox".
///
- (BOOL)isHasTeamSharedDropbox;

///
/// Retrieves whether the union's current tag state has value
/// "has_team_file_events".
///
/// @return Whether the union's current tag state has value
/// "has_team_file_events".
///
- (BOOL)isHasTeamFileEvents;

///
/// Retrieves whether the union's current tag state has value
/// "has_team_selective_sync".
///
/// @return Whether the union's current tag state has value
/// "has_team_selective_sync".
///
- (BOOL)isHasTeamSelectiveSync;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMFeature` union.
///
@interface DBTEAMFeatureSerializer : NSObject

///
/// Serializes `DBTEAMFeature` instances.
///
/// @param instance An instance of the `DBTEAMFeature` API object.
///
/// @return A json-compatible dictionary representation of the `DBTEAMFeature`
/// API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMFeature *)instance;

///
/// Deserializes `DBTEAMFeature` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMFeature` API object.
///
/// @return An instantiation of the `DBTEAMFeature` object.
///
+ (DBTEAMFeature *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
