///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAddFolderMemberError;
@class DBSHARINGSharedFolderAccessError;
@class DBSHARINGSharedFolderMemberError;
@class DBSHARINGUpdateFolderMemberError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UpdateFolderMemberError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGUpdateFolderMemberError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGUpdateFolderMemberErrorTag` enum type represents the possible
/// tag states with which the `DBSHARINGUpdateFolderMemberError` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGUpdateFolderMemberErrorTag){
    /// (no description).
    DBSHARINGUpdateFolderMemberErrorAccessError,

    /// (no description).
    DBSHARINGUpdateFolderMemberErrorMemberError,

    /// If updating the access type required the member to be added to the
    /// shared folder and there was an error when adding the member.
    DBSHARINGUpdateFolderMemberErrorNoExplicitAccess,

    /// The current user's account doesn't support this action. An example of
    /// this is when downgrading a member from editor to viewer. This action can
    /// only be performed by users that have upgraded to a Pro or Business plan.
    DBSHARINGUpdateFolderMemberErrorInsufficientPlan,

    /// The current user does not have permission to perform this action.
    DBSHARINGUpdateFolderMemberErrorNoPermission,

    /// (no description).
    DBSHARINGUpdateFolderMemberErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGUpdateFolderMemberErrorTag tag;

/// (no description). @note Ensure the `isAccessError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedFolderAccessError *accessError;

/// (no description). @note Ensure the `isMemberError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedFolderMemberError *memberError;

/// If updating the access type required the member to be added to the shared
/// folder and there was an error when adding the member. @note Ensure the
/// `isNoExplicitAccess` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGAddFolderMemberError *noExplicitAccess;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "access_error".
///
/// @param accessError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError;

///
/// Initializes union class with tag state of "member_error".
///
/// @param memberError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberError:(DBSHARINGSharedFolderMemberError *)memberError;

///
/// Initializes union class with tag state of "no_explicit_access".
///
/// Description of the "no_explicit_access" tag state: If updating the access
/// type required the member to be added to the shared folder and there was an
/// error when adding the member.
///
/// @param noExplicitAccess If updating the access type required the member to
/// be added to the shared folder and there was an error when adding the member.
///
/// @return An initialized instance.
///
- (instancetype)initWithNoExplicitAccess:(DBSHARINGAddFolderMemberError *)noExplicitAccess;

///
/// Initializes union class with tag state of "insufficient_plan".
///
/// Description of the "insufficient_plan" tag state: The current user's account
/// doesn't support this action. An example of this is when downgrading a member
/// from editor to viewer. This action can only be performed by users that have
/// upgraded to a Pro or Business plan.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientPlan;

///
/// Initializes union class with tag state of "no_permission".
///
/// Description of the "no_permission" tag state: The current user does not have
/// permission to perform this action.
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPermission;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "access_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `accessError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "access_error".
///
- (BOOL)isAccessError;

///
/// Retrieves whether the union's current tag state has value "member_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `memberError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "member_error".
///
- (BOOL)isMemberError;

///
/// Retrieves whether the union's current tag state has value
/// "no_explicit_access".
///
/// @note Call this method and ensure it returns true before accessing the
/// `noExplicitAccess` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "no_explicit_access".
///
- (BOOL)isNoExplicitAccess;

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_plan".
///
/// @return Whether the union's current tag state has value "insufficient_plan".
///
- (BOOL)isInsufficientPlan;

///
/// Retrieves whether the union's current tag state has value "no_permission".
///
/// @return Whether the union's current tag state has value "no_permission".
///
- (BOOL)isNoPermission;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGUpdateFolderMemberError` union.
///
@interface DBSHARINGUpdateFolderMemberErrorSerializer : NSObject

///
/// Serializes `DBSHARINGUpdateFolderMemberError` instances.
///
/// @param instance An instance of the `DBSHARINGUpdateFolderMemberError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGUpdateFolderMemberError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFolderMemberError *)instance;

///
/// Deserializes `DBSHARINGUpdateFolderMemberError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGUpdateFolderMemberError` API object.
///
/// @return An instantiation of the `DBSHARINGUpdateFolderMemberError` object.
///
+ (DBSHARINGUpdateFolderMemberError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
