///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGSharedFolderAccessError;
@class DBSHARINGTransferFolderError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TransferFolderError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGTransferFolderError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGTransferFolderErrorTag` enum type represents the possible tag
/// states with which the `DBSHARINGTransferFolderError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGTransferFolderErrorTag){
    /// (no description).
    DBSHARINGTransferFolderErrorAccessError,

    /// `toDropboxId` in `DBSHARINGTransferFolderArg` is invalid.
    DBSHARINGTransferFolderErrorInvalidDropboxId,

    /// The new designated owner is not currently a member of the shared folder.
    DBSHARINGTransferFolderErrorDNewOwnerNotAMember,

    /// The new designated owner has not added the folder to their Dropbox.
    DBSHARINGTransferFolderErrorDNewOwnerUnmounted,

    /// The new designated owner's email address is not verified. This
    /// functionality is only available on accounts with a verified email
    /// address. Users can verify their email address here
    /// https://www.dropbox.com/help/317.
    DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified,

    /// This action cannot be performed on a team shared folder.
    DBSHARINGTransferFolderErrorTeamFolder,

    /// The current user does not have permission to perform this action.
    DBSHARINGTransferFolderErrorNoPermission,

    /// (no description).
    DBSHARINGTransferFolderErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGTransferFolderErrorTag tag;

/// (no description). @note Ensure the `isAccessError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedFolderAccessError *accessError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "access_error".
///
/// @param accessError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError;

///
/// Initializes union class with tag state of "invalid_dropbox_id".
///
/// Description of the "invalid_dropbox_id" tag state: `toDropboxId` in
/// `DBSHARINGTransferFolderArg` is invalid.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidDropboxId;

///
/// Initializes union class with tag state of "new_owner_not_a_member".
///
/// Description of the "new_owner_not_a_member" tag state: The new designated
/// owner is not currently a member of the shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewOwnerNotAMember;

///
/// Initializes union class with tag state of "new_owner_unmounted".
///
/// Description of the "new_owner_unmounted" tag state: The new designated owner
/// has not added the folder to their Dropbox.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewOwnerUnmounted;

///
/// Initializes union class with tag state of "new_owner_email_unverified".
///
/// Description of the "new_owner_email_unverified" tag state: The new
/// designated owner's email address is not verified. This functionality is only
/// available on accounts with a verified email address. Users can verify their
/// email address here https://www.dropbox.com/help/317.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewOwnerEmailUnverified;

///
/// Initializes union class with tag state of "team_folder".
///
/// Description of the "team_folder" tag state: This action cannot be performed
/// on a team shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolder;

///
/// Initializes union class with tag state of "no_permission".
///
/// Description of the "no_permission" tag state: The current user does not have
/// permission to perform this action.
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPermission;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "access_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `accessError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "access_error".
///
- (BOOL)isAccessError;

///
/// Retrieves whether the union's current tag state has value
/// "invalid_dropbox_id".
///
/// @return Whether the union's current tag state has value
/// "invalid_dropbox_id".
///
- (BOOL)isInvalidDropboxId;

///
/// Retrieves whether the union's current tag state has value
/// "new_owner_not_a_member".
///
/// @return Whether the union's current tag state has value
/// "new_owner_not_a_member".
///
- (BOOL)isDNewOwnerNotAMember;

///
/// Retrieves whether the union's current tag state has value
/// "new_owner_unmounted".
///
/// @return Whether the union's current tag state has value
/// "new_owner_unmounted".
///
- (BOOL)isDNewOwnerUnmounted;

///
/// Retrieves whether the union's current tag state has value
/// "new_owner_email_unverified".
///
/// @return Whether the union's current tag state has value
/// "new_owner_email_unverified".
///
- (BOOL)isDNewOwnerEmailUnverified;

///
/// Retrieves whether the union's current tag state has value "team_folder".
///
/// @return Whether the union's current tag state has value "team_folder".
///
- (BOOL)isTeamFolder;

///
/// Retrieves whether the union's current tag state has value "no_permission".
///
/// @return Whether the union's current tag state has value "no_permission".
///
- (BOOL)isNoPermission;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGTransferFolderError` union.
///
@interface DBSHARINGTransferFolderErrorSerializer : NSObject

///
/// Serializes `DBSHARINGTransferFolderError` instances.
///
/// @param instance An instance of the `DBSHARINGTransferFolderError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGTransferFolderError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGTransferFolderError *)instance;

///
/// Deserializes `DBSHARINGTransferFolderError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGTransferFolderError` API object.
///
/// @return An instantiation of the `DBSHARINGTransferFolderError` object.
///
+ (DBSHARINGTransferFolderError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
