///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERPaperFolderCreateArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperFolderCreateArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERPaperFolderCreateArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The name of the new Paper folder.
@property (nonatomic, readonly, copy) NSString *name;

/// The encrypted Paper folder Id where the new Paper folder should be created.
/// The API user has to have write access to this folder or error is thrown. If
/// not supplied, the new folder will be created at top level.
@property (nonatomic, readonly, copy, nullable) NSString *parentFolderId;

/// Whether the folder to be created should be a team folder. This value will be
/// ignored if parent_folder_id is supplied, as the new folder will inherit the
/// type (private or team folder) from its parent. We will by default create a
/// top-level private folder if both parent_folder_id and is_team_folder are not
/// supplied.
@property (nonatomic, readonly, nullable) NSNumber *isTeamFolder;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param name The name of the new Paper folder.
/// @param parentFolderId The encrypted Paper folder Id where the new Paper
/// folder should be created. The API user has to have write access to this
/// folder or error is thrown. If not supplied, the new folder will be created
/// at top level.
/// @param isTeamFolder Whether the folder to be created should be a team
/// folder. This value will be ignored if parent_folder_id is supplied, as the
/// new folder will inherit the type (private or team folder) from its parent.
/// We will by default create a top-level private folder if both
/// parent_folder_id and is_team_folder are not supplied.
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name
              parentFolderId:(nullable NSString *)parentFolderId
                isTeamFolder:(nullable NSNumber *)isTeamFolder;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param name The name of the new Paper folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperFolderCreateArg` struct.
///
@interface DBPAPERPaperFolderCreateArgSerializer : NSObject

///
/// Serializes `DBPAPERPaperFolderCreateArg` instances.
///
/// @param instance An instance of the `DBPAPERPaperFolderCreateArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERPaperFolderCreateArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperFolderCreateArg *)instance;

///
/// Deserializes `DBPAPERPaperFolderCreateArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERPaperFolderCreateArg` API object.
///
/// @return An instantiation of the `DBPAPERPaperFolderCreateArg` object.
///
+ (DBPAPERPaperFolderCreateArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
