///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESUploadSessionStartError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UploadSessionStartError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESUploadSessionStartError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESUploadSessionStartErrorTag` enum type represents the possible
/// tag states with which the `DBFILESUploadSessionStartError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESUploadSessionStartErrorTag){
    /// Uploading data not allowed when starting concurrent upload session.
    DBFILESUploadSessionStartErrorConcurrentSessionDataNotAllowed,

    /// Can not start a closed concurrent upload session.
    DBFILESUploadSessionStartErrorConcurrentSessionCloseNotAllowed,

    /// (no description).
    DBFILESUploadSessionStartErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESUploadSessionStartErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of
/// "concurrent_session_data_not_allowed".
///
/// Description of the "concurrent_session_data_not_allowed" tag state:
/// Uploading data not allowed when starting concurrent upload session.
///
/// @return An initialized instance.
///
- (instancetype)initWithConcurrentSessionDataNotAllowed;

///
/// Initializes union class with tag state of
/// "concurrent_session_close_not_allowed".
///
/// Description of the "concurrent_session_close_not_allowed" tag state: Can not
/// start a closed concurrent upload session.
///
/// @return An initialized instance.
///
- (instancetype)initWithConcurrentSessionCloseNotAllowed;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "concurrent_session_data_not_allowed".
///
/// @return Whether the union's current tag state has value
/// "concurrent_session_data_not_allowed".
///
- (BOOL)isConcurrentSessionDataNotAllowed;

///
/// Retrieves whether the union's current tag state has value
/// "concurrent_session_close_not_allowed".
///
/// @return Whether the union's current tag state has value
/// "concurrent_session_close_not_allowed".
///
- (BOOL)isConcurrentSessionCloseNotAllowed;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESUploadSessionStartError` union.
///
@interface DBFILESUploadSessionStartErrorSerializer : NSObject

///
/// Serializes `DBFILESUploadSessionStartError` instances.
///
/// @param instance An instance of the `DBFILESUploadSessionStartError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESUploadSessionStartError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionStartError *)instance;

///
/// Deserializes `DBFILESUploadSessionStartError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESUploadSessionStartError` API object.
///
/// @return An instantiation of the `DBFILESUploadSessionStartError` object.
///
+ (DBFILESUploadSessionStartError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
