///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSearchMatchV2;
@class DBFILESSearchV2Result;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SearchV2Result` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSearchV2Result : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// A list (possibly empty) of matches for the query.
@property (nonatomic, readonly) NSArray<DBFILESSearchMatchV2 *> *matches;

/// Used for paging. If true, indicates there is another page of results
/// available that can be fetched by calling `searchContinue` with the cursor.
@property (nonatomic, readonly) NSNumber *hasMore;

/// Pass the cursor into `searchContinue` to fetch the next page of results.
@property (nonatomic, readonly, copy, nullable) NSString *cursor;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param matches A list (possibly empty) of matches for the query.
/// @param hasMore Used for paging. If true, indicates there is another page of
/// results available that can be fetched by calling `searchContinue` with the
/// cursor.
/// @param cursor Pass the cursor into `searchContinue` to fetch the next page
/// of results.
///
/// @return An initialized instance.
///
- (instancetype)initWithMatches:(NSArray<DBFILESSearchMatchV2 *> *)matches
                        hasMore:(NSNumber *)hasMore
                         cursor:(nullable NSString *)cursor;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param matches A list (possibly empty) of matches for the query.
/// @param hasMore Used for paging. If true, indicates there is another page of
/// results available that can be fetched by calling `searchContinue` with the
/// cursor.
///
/// @return An initialized instance.
///
- (instancetype)initWithMatches:(NSArray<DBFILESSearchMatchV2 *> *)matches hasMore:(NSNumber *)hasMore;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SearchV2Result` struct.
///
@interface DBFILESSearchV2ResultSerializer : NSObject

///
/// Serializes `DBFILESSearchV2Result` instances.
///
/// @param instance An instance of the `DBFILESSearchV2Result` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSearchV2Result` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSearchV2Result *)instance;

///
/// Deserializes `DBFILESSearchV2Result` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSearchV2Result` API object.
///
/// @return An instantiation of the `DBFILESSearchV2Result` object.
///
+ (DBFILESSearchV2Result *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
