///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESMetadata;
@class DBFILESMetadataV2;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MetadataV2` union.
///
/// Metadata for a file, folder or other resource types.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESMetadataV2 : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESMetadataV2Tag` enum type represents the possible tag states with
/// which the `DBFILESMetadataV2` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESMetadataV2Tag){
    /// (no description).
    DBFILESMetadataV2Metadata,

    /// (no description).
    DBFILESMetadataV2Other,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESMetadataV2Tag tag;

/// (no description). @note Ensure the `isMetadata` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESMetadata *metadata;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "metadata".
///
/// @param metadata (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithMetadata:(DBFILESMetadata *)metadata;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "metadata".
///
/// @note Call this method and ensure it returns true before accessing the
/// `metadata` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "metadata".
///
- (BOOL)isMetadata;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESMetadataV2` union.
///
@interface DBFILESMetadataV2Serializer : NSObject

///
/// Serializes `DBFILESMetadataV2` instances.
///
/// @param instance An instance of the `DBFILESMetadataV2` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESMetadataV2` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESMetadataV2 *)instance;

///
/// Deserializes `DBFILESMetadataV2` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESMetadataV2` API object.
///
/// @return An instantiation of the `DBFILESMetadataV2` object.
///
+ (DBFILESMetadataV2 *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
