///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESDeleteError;
@class DBFILESLookupError;
@class DBFILESWriteError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeleteError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESDeleteError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESDeleteErrorTag` enum type represents the possible tag states
/// with which the `DBFILESDeleteError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESDeleteErrorTag){
    /// (no description).
    DBFILESDeleteErrorPathLookup,

    /// (no description).
    DBFILESDeleteErrorPathWrite,

    /// There are too many write operations in user's Dropbox. Please retry this
    /// request.
    DBFILESDeleteErrorTooManyWriteOperations,

    /// There are too many files in one request. Please retry with fewer files.
    DBFILESDeleteErrorTooManyFiles,

    /// (no description).
    DBFILESDeleteErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESDeleteErrorTag tag;

/// (no description). @note Ensure the `isPathLookup` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESLookupError *pathLookup;

/// (no description). @note Ensure the `isPathWrite` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESWriteError *pathWrite;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path_lookup".
///
/// @param pathLookup (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPathLookup:(DBFILESLookupError *)pathLookup;

///
/// Initializes union class with tag state of "path_write".
///
/// @param pathWrite (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPathWrite:(DBFILESWriteError *)pathWrite;

///
/// Initializes union class with tag state of "too_many_write_operations".
///
/// Description of the "too_many_write_operations" tag state: There are too many
/// write operations in user's Dropbox. Please retry this request.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyWriteOperations;

///
/// Initializes union class with tag state of "too_many_files".
///
/// Description of the "too_many_files" tag state: There are too many files in
/// one request. Please retry with fewer files.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyFiles;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path_lookup".
///
/// @note Call this method and ensure it returns true before accessing the
/// `pathLookup` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path_lookup".
///
- (BOOL)isPathLookup;

///
/// Retrieves whether the union's current tag state has value "path_write".
///
/// @note Call this method and ensure it returns true before accessing the
/// `pathWrite` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path_write".
///
- (BOOL)isPathWrite;

///
/// Retrieves whether the union's current tag state has value
/// "too_many_write_operations".
///
/// @return Whether the union's current tag state has value
/// "too_many_write_operations".
///
- (BOOL)isTooManyWriteOperations;

///
/// Retrieves whether the union's current tag state has value "too_many_files".
///
/// @return Whether the union's current tag state has value "too_many_files".
///
- (BOOL)isTooManyFiles;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESDeleteError` union.
///
@interface DBFILESDeleteErrorSerializer : NSObject

///
/// Serializes `DBFILESDeleteError` instances.
///
/// @param instance An instance of the `DBFILESDeleteError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESDeleteError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteError *)instance;

///
/// Deserializes `DBFILESDeleteError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESDeleteError` API object.
///
/// @return An instantiation of the `DBFILESDeleteError` object.
///
+ (DBFILESDeleteError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
