///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEREQUESTSGracePeriod;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GracePeriod` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEREQUESTSGracePeriod : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILEREQUESTSGracePeriodTag` enum type represents the possible tag
/// states with which the `DBFILEREQUESTSGracePeriod` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILEREQUESTSGracePeriodTag){
    /// (no description).
    DBFILEREQUESTSGracePeriodOneDay,

    /// (no description).
    DBFILEREQUESTSGracePeriodTwoDays,

    /// (no description).
    DBFILEREQUESTSGracePeriodSevenDays,

    /// (no description).
    DBFILEREQUESTSGracePeriodThirtyDays,

    /// (no description).
    DBFILEREQUESTSGracePeriodAlways,

    /// (no description).
    DBFILEREQUESTSGracePeriodOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILEREQUESTSGracePeriodTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "one_day".
///
/// @return An initialized instance.
///
- (instancetype)initWithOneDay;

///
/// Initializes union class with tag state of "two_days".
///
/// @return An initialized instance.
///
- (instancetype)initWithTwoDays;

///
/// Initializes union class with tag state of "seven_days".
///
/// @return An initialized instance.
///
- (instancetype)initWithSevenDays;

///
/// Initializes union class with tag state of "thirty_days".
///
/// @return An initialized instance.
///
- (instancetype)initWithThirtyDays;

///
/// Initializes union class with tag state of "always".
///
/// @return An initialized instance.
///
- (instancetype)initWithAlways;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "one_day".
///
/// @return Whether the union's current tag state has value "one_day".
///
- (BOOL)isOneDay;

///
/// Retrieves whether the union's current tag state has value "two_days".
///
/// @return Whether the union's current tag state has value "two_days".
///
- (BOOL)isTwoDays;

///
/// Retrieves whether the union's current tag state has value "seven_days".
///
/// @return Whether the union's current tag state has value "seven_days".
///
- (BOOL)isSevenDays;

///
/// Retrieves whether the union's current tag state has value "thirty_days".
///
/// @return Whether the union's current tag state has value "thirty_days".
///
- (BOOL)isThirtyDays;

///
/// Retrieves whether the union's current tag state has value "always".
///
/// @return Whether the union's current tag state has value "always".
///
- (BOOL)isAlways;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILEREQUESTSGracePeriod` union.
///
@interface DBFILEREQUESTSGracePeriodSerializer : NSObject

///
/// Serializes `DBFILEREQUESTSGracePeriod` instances.
///
/// @param instance An instance of the `DBFILEREQUESTSGracePeriod` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEREQUESTSGracePeriod` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSGracePeriod *)instance;

///
/// Deserializes `DBFILEREQUESTSGracePeriod` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEREQUESTSGracePeriod` API object.
///
/// @return An instantiation of the `DBFILEREQUESTSGracePeriod` object.
///
+ (DBFILEREQUESTSGracePeriod *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
