//
//  NSString+Additions.h
//
//
//  Created by Mike on 13/4/29.
//
//

#import <Foundation/Foundation.h>
#import <CoreGraphics/CoreGraphics.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

extern NSString *NSStringAdditions_FileNameInvlidCharacters;

typedef NS_OPTIONS(NSUInteger, NSStringTransformOption)
{
    NSStringTransformOption_Alphabet = 1<<0,
    NSStringTransformOption_Symbol = 1<<1,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NSString (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (NSUInteger)countOccurencesOf:(NSString *)subString options:(NSStringCompareOptions)mask;
- (NSString *)localized;
- (NSString *)localizedFromTable:(NSString *)table;
- (NSString *)localizedFromTable:(NSString *)table inBundle:(NSBundle *)bundle;

/**
 *  Remove Html tags from string
 *
 *  @return String removed HTML tags
 */
- (NSString *)stringByStrippingHTMLTags;
- (NSString *)stringReplacingHtmlSpecialCharacters;
- (NSString *)stringReplacingInvlidFileNameCharacters;
- (BOOL)isEmail;
- (BOOL)isGUID;
- (BOOL)isURL;
- (BOOL)isCJK;
- (BOOL)isThai;

/// 文字中是否包含韓文
- (BOOL)hasKorean;

/// 是否有日文字
- (BOOL)hasJapanese;

/// 是否有非法字元 (0xffff)
- (BOOL)hasInvalidCharacter;

- (NSString *)semiShapedStringWithOptions:(NSStringTransformOption)options;
- (NSString *)fullShapedStringWithOptions:(NSStringTransformOption)options;

/**
 * 將字串中的文字轉為繁中後回傳
 * @return 轉換為繁中的文字
 */
- (NSString *)traditionalChineseString;

/**
 * 將字串中的文字轉為簡中後回傳
 * @return 轉換為簡中的文字
 */
- (NSString *)simplifiedChineseString;

/**
 * 將字串中的片假名轉為平假名
 * @return 轉換為平假名的文字
 */
- (NSString *)hiraganaString;

/**
 * 將字串中的平假名轉為片假名
 * @return 轉換為片假名的文字
 */
- (NSString *)katakanaString;

/**
 * 將16進位表示的數值字串轉換為NSData物件
 * @return 轉換完的byte資料
 */
- (NSData *)hexToData;

/**
 * 將字串前後的空白和換行拿掉
 * @return 處理後的字串
 */
- (NSString *)stringByTrimmingUnvisibleChar;

/**
 * 將字串的換行符號改成空白
 * @return 處理後的字串
 */
- (NSString *)stringByReplacingNewLine;

/**
 * 不分大小寫的unicode編碼比對
 * @return 比對結果
 */
- (NSComparisonResult)unicodeCompare:(NSString *)string;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (NSString *)GUID;
+ (NSString *)stringWithPoint:(CGPoint)point;
+ (NSString *)stringWithRect:(CGRect)rect;
+ (NSString *)stringWithSize:(CGSize)size;
+ (NSString *)stringWithInteger:(NSInteger)integer;

/// 將data轉換成hex格式字串
+ (NSString *)stringWithData:(NSData *)data;

+ (BOOL)isAlphabetCharacter:(unichar)character;
+ (BOOL)isCJKCharacter:(unichar)character;
+ (BOOL)isThaiCharacter:(unichar)character;
+ (BOOL)isKoreanCharacter:(unichar)character;
+ (BOOL)isInvalidCharacter:(unichar)character;
+ (BOOL)isSymbolCharacter:(unichar)character;

+ (void)setUserDefinedLanguage:(NSString *)language;
+ (NSString *)userDefinedLanguage;
@end
