//
//  WCTRestClient+Search.h
//  
//
//  Created by Howard on 2016/3/29.
//
//

#import "WCTRestClient.h"
#import "WCTRCSearchPublicContactsByKeywordResponseResult.h"
#import "WCTRCSearchPrivateContactsByKeywordResponseResult.h"
#import "WCTRCSearchPublicContactsByKeywordSortedResponseResult.h"
#import "WCTRCAdvancedSearchVoRequest.h"
#import "WCTRCAdvancedSearchContactListResposeResult.h"

@interface WCTRestClient (Search)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  透過關鍵字搜尋公司連絡人
 *
 *  @param loginToken 登入Token
 *  @param keyword    關鍵字
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)searchPublicContactsByKeywordWithLoginToken:(NSString *)loginToken
                                                                  keyword:(NSString *)keyword
                                                                  success:(void (^)(WCTRCSearchPublicContactsByKeywordResponseResult *searchPublicContactsByKeywordResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure;


/**
 *  透過關鍵字搜尋共享聯絡人
 *
 *  @param loginToken                 登入token
 *  @param keyword                    關鍵字
 *  @param page                       頁碼
 *  @param pageSize                   每頁幾筆
 *  @param contactsimpleinfoSortField 排序欄位
 *  @param sortDirection              排序順序
 *  @param success                    成功回傳
 *  @param failure                    失敗回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)searchPublicContactsByKeywordSortedWithLoginToken:(NSString *)loginToken
                                                                        keyword:(NSString *)keyword
                                                                           page:(NSUInteger)page
                                                                       pageSize:(NSUInteger)pageSize
                                                     contactsimpleinfoSortField:(NSString *)contactsimpleinfoSortField
                                                                  sortDirection:(NSString *)sortDirection
                                                                        success:(void (^)(WCTRCSearchPublicContactsByKeywordSortedResponseResult *searchPublicContactsByKeywordSortedResponseResult))success
                                                                        failure:(void (^)(NSError *error))failure;



/**
 *  透過關鍵字搜尋我的連絡人
 *
 *  @param loginToken 登入Token
 *  @param keyword    關鍵字
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)searchPrivateContactsByKeywordWithLoginToken:(NSString *)loginToken
                                                                   keyword:(NSString *)keyword
                                                                   success:(void (^)(WCTRCSearchPrivateContactsByKeywordResponseResult *searchPrivateContactsByKeywordResponseResult))success
                                                                   failure:(void (^)(NSError *error))failure;
/**
 *  透過條件組合搜尋聯絡人，WCTRCAdvancedSearchVoRequest中的contactRangeType決定是搜尋我的聯絡人或是共享聯絡人
 *
 *  @param loginToken 登入Token
 *  @param request    搜尋條件
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)advancedSearchWithLoginToken:(NSString *)loginToken
                                                   request:(WCTRCAdvancedSearchVoRequest *)request
                                                   success:(void (^)(WCTRCAdvancedSearchContactListResposeResult *searchResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;
@end
