//
//  PPVersionInfo.h
//  Pods
//
//  Created by sanhue on 2017/5/24.
//
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, PPComparisonResult)
{
    PPComparisonResult_LessThan = -1,
    PPComparisonResult_Equal,
    PPComparisonResult_GreatThan,
};

//////////////////////////////////////////////////
@interface PPVersionInfo : NSObject<NSCopying>

@property (nonatomic, assign) NSInteger majorVersion;
@property (nonatomic, assign) NSInteger minorVersion;
@property (nonatomic, assign) NSInteger patchVersion;

- (instancetype)init UNAVAILABLE_ATTRIBUTE;
/**
 * 比較兩個版號大小
 * @param versionInfo 要用來比對的版號
 * @return 比對結果 PPComparisonResult，PPComparisonResult_LessThan:self<versionInfo;PPComparisonResult_GreatThan:self>versionInfo;PPComparisonResult_Equal:self=versionInfo
 */
- (PPComparisonResult)compare:(PPVersionInfo *)versionInfo;

/**
 * 回傳版號字串
 * @return 版號 格式 %@.%@.%@
 */
- (NSString *)versionString;

#pragma mark Class methods
/**
 * 建立versionInfo, 預設
 * @param versionString 輸入版號，格式為 %@.%@.%@
 * @return versionInfo instance of PPVersionInfo
 */
+ (instancetype)versionInfoWithVersionString:(NSString*)versionString;

@end
