//
//  WCTPasswordViewController+ParameterDefine.h
//  
//
//  Created by Howard on 2016/4/21.
//
//

#ifndef WCTPasswordViewController_ParameterDefine_h
#define WCTPasswordViewController_ParameterDefine_h

#import "NSError+Custom.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Style Define

typedef NS_ENUM (NSUInteger, WCTPasswordViewControllerStyle)
{
    WCTPasswordViewControllerStyle_ChangePassword,
    WCTPasswordViewControllerStyle_ResetPassword,
    WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired, ///< 密碼過期要重設密碼
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Error Code Define

typedef NS_ENUM(NSUInteger, NSErrorPasswordViewController_Code)
{
    NSErrorPasswordViewController_Code_PassowrdLengthIsIllegal = NSErrorCustom_Code_UserDefine,
    NSErrorPasswordViewController_Code_PasswordFormatIsIllegal,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Button Tag

typedef NS_ENUM(NSUInteger, WCTPVControllerButtonTag)
{
    WCTPVControllerButtonTag_Back,
    WCTPVControllerButtonTag_Done,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlertView Tag

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTPasswordViewControllerAlertViewTag)
{
    WCTPasswordViewControllerAlertViewTag_ChangePasswordFail,
    WCTPasswordViewControllerAlertViewTag_ChangePasswordSuccessful,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTCPSControllerSection)
{
    WCTCPSControllerSection_OriginalPassword,
    WCTCPSControllerSection_NewPassword,
    WCTCPSControllerSection_CheckPassword,
    WCTCPSControllerSection_ShowPassword,
};

typedef NS_ENUM(NSUInteger, WCTCPSCSectionOriginalPassword_Row)
{
    WCTCPSCSectionOriginalPassword_Row_OriginalPassword,
};


typedef NS_ENUM(NSUInteger, WCTCPSControllerSectionNewPassword_Row)
{
    WCTCPSControllerSectionNewPassword_Row_NewPassword,
};


typedef NS_ENUM(NSUInteger, WCTCPSControllerSectionCheckPassword_Row)
{
    WCTCPSControllerSectionCheckPassword_Row_CheckPassword,
};

typedef NS_ENUM(NSUInteger, WCTCPSControllerSectionShowPassword_Row)
{
    WCTCPSControllerSectionShowPassword_Row_ShowPassword,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Password Define

static NSInteger const WCTPasswordViewController_MinimumPassword = 6;
static NSInteger const WCTPasswordViewController_MaximumPassword = 16;

#endif /* WCTPasswordViewController_ParameterDefine_h */
