//
//  WCTLoginViewController+ResourceDefine.h
//
//
//  Created by Howard on 2016/3/18.
//
//

#ifndef WCTLoginViewController_ResourceDefine_h
#define WCTLoginViewController_ResourceDefine_h

#import "UIColor+HexString.h"
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Color Define

#define WCTLVC_IPadBackgroundColor [UIColor colorWithRed:240 green:239 blue:245 alpha:1]
#define WCTLVC_TextFieldTextColor [UIColor colorWithHexString:@"#797979"]
#define WCTLVC_TextFieldHighlightedTextColor [UIColor colorWithHexString:@"#3f79cf"]

#define WCTLVC_PlaceholderTextColor [UIColor colorWithHexString:@"#d1d1d1"]
#define WCTLVC_TextFieldBorderColor [UIColor colorWithHexString:@"#9cbff3"]

#define WCTLVC_LoginButton_NormalBackgroundColor [UIColor colorWithHexString:@"#3fa1e8"]
#define WCTLVC_LoginButton_HighlightedBackgroundColor [UIColor colorWithHexString:@"#2094e8"]
#define WCTLVC_LoginButton_NormalTextColor [UIColor colorWithHexString:@"#ffffff"]
#define WCTLVC_LoginButton_HighlightedTextColor [UIColor colorWithHexString:@"#dcefff"]


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - MultiLanguage

#define WCTLV @"WCTLoginViewController"

// commmon
#define WCTLV_MLS_WCTAppName [@"MLS_About_WCTAppName" localized]
#define WCTLV_MLS_OK [@"MLS_OK" localized]
#define WCTLV_MLS_Cancel [@"MLS_Cancel" localized]
#define WCTLV_MLS_NO [@"MLS_No" localized]
#define WCTLV_MLS_FailedToConnectServer [@"MLS_FailedToConnectServer" localized]
#define WCTLV_MLS_Copy [@"MLS_Copy" localized]
#define WCTLV_MLS_ServerRestoreWarning [@"MLS_ServerRestoreWarning" localized]

#define WCTLV_MLS_UseSSLConnection [@"MLS_UseSSLConnection" localizedFromTable:WCTLV]
#define WCTLV_MLS_AutoLogin [@"MLS_AutoLogin" localizedFromTable:WCTLV]
#define WCTLV_MLS_Login [@"MLS_Login" localizedFromTable:WCTLV]
#define WCTLV_MLS_Password [@"MLS_Password" localizedFromTable:WCTLV]
#define WCTLV_MLS_Server [@"MLS_Server" localizedFromTable:WCTLV]
#define WCTLV_MLS_User [@"MLS_User" localizedFromTable:WCTLV]
#define WCTLV_MLS_Report [@"MLS_Report" localized]
#define WCTLV_MLS_ForgetPassword [@"MLS_ForgetPassword" localizedFromTable:WCTLV]

#define WCTLV_MLS_Register [@"MLS_Register" localized]
#define WCTLV_MLS_Manual [@"MLS_Manual" localized]


#define WCTLV_MLS_ForSecurityAskIfConnectWithHttps [@"MLS_ForSecurityAskIfConnectWithHttps" localizedFromTable:WCTLV]
#define WCTLV_MLS_Port [@"MLS_Port" localizedFromTable:WCTLV]
#define WCTLV_MLS_DeviceName [@"MLS_DeviceName" localizedFromTable:WCTLV]
#define WCTLV_MLS_DeviceNameAndID [@"MLS_DeviceNameAndID" localizedFromTable:WCTLV]
#define WCTLV_MLS_DeviceID [@"MLS_DeviceID" localizedFromTable:WCTLV]
#define WCTLV_MLS_Send [@"MLS_Send" localizedFromTable:WCTLV]

#define WCTLV_MLS_UpdateClient [@"MLS_UpdateClient" localizedFromTable:WCTLV]
#define WCTLV_MLS_OfflineLogin [@"MLS_OfflineLogin" localizedFromTable:WCTLV]
#define WCTLV_MLS_Subscription [@"MLS_Subscription" localizedFromTable:WCTLV]
#define WCTLV_MLS_SubscriptionBuy [@"MLS_SubscriptionBuy" localizedFromTable:WCTLV]


////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString * const ImageNameWCTLoginViewControllerHeaderBackground   = @"WCTLoginViewControllerHeaderBackground";
static NSString * const ImageNameWCTLoginViewControllerContentBackground  = @"WCTLoginViewControllerContentBackground";
static NSString * const ImageNameWCTLoginViewControllerButtonShowPassword  = @"WCTLoginViewControllerButtonShowPassword";
static NSString * const ImageNameWCTLoginViewControllerButtonHidePassword  = @"WCTLoginViewControllerButtonHidePassword";
static NSString * const ImageNameWCTLoginViewControllerButtonDrop  = @"WCTLoginViewControllerButtonDrop";

////////////////////////////////////////////////////////////////////////////////////////////////////

#define LoginCloudLoginWidthFactor        ((UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad) ? 0.25 : 0.35)

////////////////////////////////////////////////////////////////////////////////////////////////////

static UIEdgeInsets const WCTLoginViewControllerTableViewEdgeInsets = {16,16,0,16};

static CGFloat const WCTLoginViewControllerForgetPasswordButtonHeight = 28;
static CGFloat const WCTLoginViewControllerForgetPasswordButtonFontSize = 16;
static UIEdgeInsets const WCTLoginViewControllerForgetPasswordButtonEdgeInset = {0,0,0,10};

static CGFloat const WCTLoginViewControllerHelpButtonHeight = 28;
static CGFloat const WCTLoginViewControllerHelpButtonFontSize = 16;
static UIEdgeInsets const WCTLoginViewControllerHelpButtonEdgeInset = {0,0,0,10};

static CGFloat const WCTLoginViewControllerDeviceIDButtonHeight = 28;
static CGFloat const WCTLoginViewControllerDeviceIDButtonFontSize = 16;
static UIEdgeInsets const WCTLoginViewControllerDeviceIDButtonEdgeInset = {0,10,0,0};


static CGFloat const WCTLoginViewControllerLoginButtonHeight = 44;
static CGFloat const WCTLoginViewControllerLoginButtonFontSize = 16;
static CGFloat const WCTLoginViewControllerServerListViewWidth = 272;
static CGFloat const WCTLoginViewControllerServerListViewCellHeight = 66;

static CGFloat const WCTLoginViewControllerAutoLoginButtonFontSize = 16;
static NSString * const WCTLoginViewControllerServerName  = @"WorldCardTeam";
static CGFloat const WCTLoginViewControllerServertListFontSize = 18;

#endif /* WCTLoginViewController_ResourceDefine_h */
