//
//  WCDataController.h
//  WorldCard series
//
//  Created by  Eddie on 12/4/9.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//
//
//  !! WCDataController 是 WorldCard Mobile/HD 共用的資料處理元件
//  !! 如果需要修改必須考量是針對WorldCard系列產品或單一產品
//  !! 若是對系列產品請記得要一並更新到其他產品
//  !! 若是對單一產品的修改請繼承此物件後再利用覆寫或新增函式的方式處理
//
//


// define
#import "WCGroupDefine.h"
#import "WCImageDefine.h"
#import "WCSourceDefine.h"

#import "WCDataControllerProtocol.h"
#import "WCTDataControllerProtocol.h"

// model
#import "WCCardModel.h"
#import "WCABCardModel.h"
#import "WCFieldModel.h"
#import "WCGroupModel.h"
#import "WCTAdvancedSearchModel.h"


@class WCTCardDBController;

////////////////////////////////////////////////////////////////////////////////////////////////////
// General definition

#define WCDC_DBName             @"card.db"
#define WCDC_TempCardID         @"000"

/// local disk最小保留空間 (50MB)
#define WCDC_MinDiskSpace       50.0*1024*1024


////////////////////////////////////////////////////////////////////////////////////////////////
// error definition (需要特別處理的才需要定義，一般問題用WCDC_ErrorCode_Normal)


#define WCDC_ErrorDomain                                  @"WCTDataControllerError"
#define WCDC_ErrorCode_Normal                             8000
#define WCDC_ErrorCode_GetCardNotExist                    8001


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTDataController : NSObject <WCDataControllerProtocol, WCTDataControllerProtocol>

@property (nonatomic, retain) NSError *lastError;
@property (nonatomic, assign) WC_SourceID sourceID; // macOS版有多重source

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle

- (WCTCardDBController *)cardDBController;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Other methods

/// 以舊cardID查詢GUID
- (NSString *)cardIDWithImportedCardID:(NSString *)importedCardID;

/// 設定舊的cardID與GUID的mapping
- (BOOL)setImporedCardID:(NSString *)importedCardID withCardID:(NSString *)cardID;

/// 移除mapping
- (BOOL)removeImportedCardIDWithCardID:(NSString *)cardID;

/// 取消讀取名片分類資料
- (void)cancelLoadCardSections;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Indivisual Group methods

/// 根據guid自動判斷要新增還是更新群組資料
- (BOOL)addOrUpdateGroupWithGuid:(NSString *)guid name:(NSString *)name superGroupGuid:(NSString *)superGroupGuid helper:(NSString *)helper;

/// 更新superGroupGuid
- (BOOL)updateSuperGroupGuid:(NSString *)superGroupGuid withGroupID:(WC_GroupID)groupID;

/// 清除所有pinned order
- (BOOL)clearAllGroupPinnedOrder;

/// 更新釘選順序, 0表示不釘選
- (BOOL)updatePinnedOrder:(NSInteger)pinnedOrder withGroupGuid:(NSString *)groupGuid;

/// 取得釘選列表，getCardCount==YES表示要取名片個數
- (NSMutableArray *)pinnedGroupsAndGetCardCount:(BOOL)getCardCount;

/// 取得groupGuid
- (NSString *)groupGuidWithID:(WC_GroupID)groupID;

/// 取得groupHelper
- (NSString *)groupHelperWithID:(WC_GroupID)groupID;

/// 指定刪除群組後沒有分類名片要歸類到哪個群組，預設是Unfiled。
- (void)setMustHaveGroupIDAfterRemoveGroup:(WC_GroupID)groupID;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Advance Search methods

/// 進階搜尋我的最愛，回傳array of WCCardModel
- (NSMutableArray *)copyFavoritesCardSectionModelsWithAdvancedSearchModel:(WCTAdvancedSearchModel *)advanceSearchModel;

/// 進階搜尋所有聯絡人，回傳array of WCCardModel
- (NSMutableArray *)copyCardSectionModelsWithAdvancedSearchModel:(WCTAdvancedSearchModel *)advanceSearchModel;

/// 進階搜尋所有聯絡人，回傳成功或失敗，資料直接更新到cache。 (for WCTMAC)
- (BOOL)loadCardSectionsWithAdvancedSearchModel:(WCTAdvancedSearchModel *)advancedSearchModel;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

/// data資料夾路徑
+ (NSString *)dataDirPath;

@end
