//
//  WCTViewGroupSelectViewController.h
//  ADAL
//
//  Created by sanhue on 2018/3/28.
//

#import <Foundation/Foundation.h>
#import "PPViewController.h"


@class WCGroupModel;
@class WCTCompanyGroupSelectViewController;

typedef NS_ENUM(NSInteger, WCTCompanyGroupSelectViewControllerErrorCode)
{
    WCTCompanyGroupSelectViewControllerErrorCode_None = 0,
    WCTCompanyGroupSelectViewControllerErrorCode_GetCategoryListFailed,
    WCTCompanyGroupSelectViewControllerErrorCode_FailedToCreateCategory,
    WCTCompanyGroupSelectViewControllerErrorCode_FailedToRenameCategory,
    WCTCompanyGroupSelectViewControllerErrorCode_FailedToMoveCategory,
    WCTCompanyGroupSelectViewControllerErrorCode_FailedToDeleteCategory
};


@protocol WCTCompanyGroupSelectViewControllerDelegate <NSObject>

/**
 * 取得帳號列表,  頁面一出現就會呼叫
 * @param error 回傳錯誤
 * @return aray of WCGroupModel, root為ALL，subgroups為account
 */
- (NSMutableArray *)accountListWithError:(NSError **)error;

@optional


/**
 * 取得此帳號的分享名片張數
 * @param accountGuid 要取得的帳號
 * @param error 回傳錯誤
 * @return aray of WCGroupModel, root為ALL，subgroups為account
 */
- (NSInteger)cardCountWithAccountGuid:(NSString *)accountGuid error:(NSError **)error;

/**
 * 是否顯示帳號列表中的名片數
 * @param error 回傳錯誤
 * @return aray of WCGroupModel, root為ALL，subgroups為account
 */
- (BOOL)shouldShowSimplifyUI:(NSError **)error;

/**
 * 取得某個帳號下的群組，展開帳號時才會呼叫
 * @param accountGuid 要取得的帳號guid
 * @param error 回傳錯誤
 * @return aray of WCGroupModel, 回傳account下的第一層群組
 */
- (NSMutableArray *)groupArrayWithAccountGuid:(NSString *)accountGuid error:(NSError **)error;


/**
 * 取得某個帳號下的群組的分享數量
 * @param categoryGuids 要取得的群組guid列表
 * @param ownerGuid 要取得的帳號guid
 * @param error 回傳錯誤
 * @return aray of WCGroupModel, 回傳account下的第一層群組
 */
- (NSDictionary <NSString*, NSNumber *> *)sharedContactNumberWithCategoryGuids:(NSArray <NSString *>*)categoryGuids ownerGuid:(NSString *)ownerGuid error:(NSError **)error;

/**
 * 確定選取的通知
 * @param companyGroupSelectViewController instance of companyGroupSelectViewController
 * @param accountGuid 選取的帳號guid
 * @param accountName 選取的帳號名稱
 * @param categoryGuid 選取的category guid,  nil表示要顯示這個帳號下的全部名片
 * @param categoryFullName 類別的完整路徑
 */
- (void)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                didSelectWithAccountGuid:(NSString *)accountGuid
                             accountName:(NSString *)accountName
                            categoryGuid:(NSString *)categoryGuid
                        categoryFullName:(NSString *)categoryFullName;
/**
 * 通知切換檢視要關閉
 * @param companyGroupSelectViewController instance of companyGroupSelectViewController
 */
- (void)didFinishCompanyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController;

/**
 * 通知切換檢視要關閉
 * @param companyGroupSelectViewController instance of companyGroupSelectViewController
 * @param error 要轉換的錯誤
 * @return 回傳要顯示的錯誤訊息
 */
- (NSString*)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController requestMessageWithError:(NSError *)error;


#pragma mark - error message handler
/**
 * 客制化錯誤
 * @param companyGroupSelectViewController WCTCompanyGroupSelectViewController
 * @param error 目前錯誤
 * @return 要顯示的錯誤字串，沒有要客制化則回傳nil，會顯示預設錯誤訊息
 */
- (NSString *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController requestErrorMessageForError:(NSError *)error;

@end

@protocol WCTCompanyGroupSelectViewControllerEditCategoryDelegate <NSObject>
@optional


#pragma mark - for group add

/**
 *  詢問group名稱是否已存在，不存在才可以新增
 *
 *  @param companyGroupSelectViewController WCTCompanyGroupSelectViewController
 *  @param groupNamed                  要詢問的群組名稱
 */
- (BOOL)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController isExistGroupNamed:(NSString*)groupNamed;

/**
 *  新增按下確定後，通知要新增群組，並回傳新增後的群組資訊
 *
 *  @param companyGroupSelectViewController WCTCompanyGroupSelectViewController
 *  @param groupName           新增的群組名稱
 *  @param ownerGuid           群組的擁有者，nil表示是自已
 *  @param superGroupGuid      父類別ID
 *  @param error               回傳錯誤
 */
- (WCGroupModel *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                          groupModelByNewGroupName:(NSString *)groupName
                                         ownerGuid:(NSString *)ownerGuid
                                    superGroupGuid:(NSString *)superGroupGuid
                                             error:(NSError **)error;

#pragma mark - for rename, delete

/**
 *  編輯按下確定後，通知要更新群組
 *
 *  @param companyGroupSelectViewController WCTCompanyGroupSelectViewController
 *  @param groupModel                  要更新的群組
 *  @return 更新失敗原因
 */
- (NSError *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController updateGroupModel:(WCGroupModel *)groupModel;

/**
 * 更名後通知完整路徑
 * @param companyGroupSelectViewController instance of companyGroupSelectViewController
 * @param guid 選取的group guid
 * @param categoryFullName 選取的類別名稱
 */
- (void)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                 categoryChangedWithGuid:(NSString *)guid
                                fullName:(NSString *)fullName;

/**
 *  按下刪除後，通知要刪除群組
 *
 *  @param companyGroupSelectViewController WCTCompanyGroupSelectViewController
 *  @param groupModel                  要刪除的群組
 */
- (NSError *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController deleteGroupModel:(WCGroupModel *)groupModel;

@end
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTCompanyGroupSelectViewController : PPViewController


@property (nonatomic, assign) id<WCTCompanyGroupSelectViewControllerDelegate> delegate;
@property (nonatomic, assign) id<WCTCompanyGroupSelectViewControllerEditCategoryDelegate> editCategoryDelegate;

///  titleString, default nil
@property (nonatomic, retain) NSString *titleString;

/// 幫同事掃描也用這個介面，但多了新增，更名，刪除
@property (nonatomic, assign) BOOL enableEditCategoryUI;

/// 是否隱藏根節點
@property (nonatomic, assign) BOOL hideRootNode;

/// 指定上次active的cell，default nil;
@property (nonatomic, retain) NSString *currentAccountGuid;
@property (nonatomic, retain) NSString *currentGroupGuid;


- (void)showFromViewController:(UIViewController *)viewController forcePresent:(BOOL)forcePresent;

@end
