//
//  WCTCompanyContactFetchDataController.h
//  
//
//  Created by Howard on 2016/4/12.
//
//

#import <Foundation/Foundation.h>

// Define
#import "WCTCompanyContactFetchDataControllerDelegate.h"

// Controller
#import "WCTRestClientController.h"

@class WCGroupModel;

//////////////////////////////////////////////////
@interface WCTCompanyContactFetchDataController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (atomic,assign) id<WCTCompanyContactFetchDataControllerDelegate> delegate;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (WCTCompanyContactFetchDataController *)shareInstance;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  等待所有操作結束
 */
- (void)waitAllFetchDataOperationFinished;


/**
 *  取消所有操作
 */
- (void)cancelFetchDataOperation;


/**
 *  取得帳號下連絡人資訊
 *
 *  @param accountGuid 求要的帳號guid
 *  @param categoryGuid 要求的category guid, nil表示要取帳號下的全部
 *  @param pageIndex 回傳第幾頁
 */

- (void)fetchCardSectionModelWithContactAccountGuid:(NSString *)accountGuid
                                       categoryGuid:(NSString *)categoryGuid
                                          pageIndex:(NSInteger)pageIndex;



/**
 *  依進階搜尋的條件取得帳號下聯絡人資訊
 *
 *  @param advancedSearchInfo 進階搜尋的條件
 *  @param pageIndex 回傳第幾頁
 */
- (void)fetchCardSectionModelWithAdvancedSearchInfo:(WCTRCAdvancedSearchInfo *)advancedSearchInfo pageIndex:(NSInteger)pageIndex;


/**
 *  透過關鍵字搜尋連絡人
 *
 *  @param searchText 關鍵字
 */
- (void)contactListSearchWithSearchText:(NSString *)searchText;


/**
 *  透過關鍵字搜尋連絡人，一頁一頁回傳
 *
 *  @param keyword                    關鍵字
 *  @param page                       頁碼
 *  @param pageSize                   每頁幾筆
 *  @param contactsimpleinfoSortField 排序欄位
 *  @param sortDirection              冪次
 */
- (void)contactListSearchWithKeywordSortedWithKeyword:(NSString *)keyword
                                                 page:(NSUInteger)page
                                             pageSize:(NSUInteger)pageSize
                           contactsimpleinfoSortField:(NSString *)contactsimpleinfoSortField
                                        sortDirection:(NSString *)sortDirection;


/**
 刪除連絡人

 @param contactGuids 連絡人 guids
 @param progressHandler 進度回傳
 @param complete 刪除連絡人結果回傳
 */
- (void)deleteContactWithContactGuids:(NSArray *)contactGuids
                      progressHandler:(void(^)(CGFloat progress))progressHandler
                             complete:(void(^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete;


/**
 *  分享名片給帳號
 *
 *  @param contactGuids 名片 Guid
 *  @param accountGuids 帳號 Guid
 *  @param shareBehavior 分享行為 WCTRC_Behavior_Add, WCTRC_Behavior_Overwrite, or WCTRC_Behavior_Remove
 *  @param progressHandler 進度回傳
 *  @param complete      結束回傳
 */
- (void)shareContactsWithContactGuids:(NSArray *)contactGuids
                       toAccountGuids:(NSArray *)accountGuids
                        shareBehavior:(NSString *)shareBehavior
                      progressHandler:(void(^)(CGFloat progress))progressHandler
                             complete:(void(^)(NSError *error))complete;


/**
 *  取得連絡人詳細資料
 *
 *  @param contactGuid 名片 Guid
 */
- (void)detailContactWithContactGuid:(NSString *)contactGuid;


/**
 *  取得名片圖
 *
 *  @param contactGuid 名片 id
 *  @param imageType   WCTRC_ImageType_Front, WCTRC_ImageType_Rear, WCTRC_ImageType_Logo
 *  @param error       回傳錯誤
 *
 *  處理方式: 背景 Thread 使用
 *  @return 名片圖
 */
- (UIImage *)contactImageWithContactGuid:(NSString *)contactGuid
                               imageType:(NSString *)imageType
                                   error:(NSError **)error;

/**
 *  取得群組列表
 *
 *  @param error 回傳錯誤
 *
 *  @return 群組列表
 */
- (NSMutableArray *)categoryListWithError:(NSError **)error;

/**
 *  取得指定帳號的群組列表
 *
 *  @param error 回傳錯誤
 *
 *  @return 群組列表
 */
- (NSMutableArray *)categoryListWithAccountGuid:(NSString *)accountGuid error:(NSError **)error;

/**
 *  更新名片至類別的操作
 *
 *  @param contactGuids  來源聯絡人guids
 *  @param categoryGuids 目標類別 guids
 *  @param progressHandler 進度回傳
 *  @param complete      結束回傳
 */
- (void)contactCategoryOperationWithContactGuids:(NSArray *)contactGuids
                                    catgoryGuids:(NSArray *)categoryGuids
                                 progressHandler:(void(^)(CGFloat progress))progressHandler
                                        complete:(void (^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete;


/**
 設定名片擁有者
 
 @param contactGuids 來源聯絡人guids
 @param ownerGuid    擁有者guid
 @param progressHandler 進度回傳
 @param complete 結束回傳
 */
- (void)setContactOwnerWithContactGuids:(NSArray *)contactGuids
                              ownerGuid:(NSString *)ownerGuid
                        progressHandler:(void(^)(CGFloat progress))progressHandler
                               complete:(void(^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete;

/**
 取得所有自訂欄位

 @param error 回傳錯誤
 @return The array of WCCustomFieldInfo
 */
- (NSArray *)contactCustomFieldsWithError:(NSError **)error;


/**
 *  取得All Company contact node
 *
 *  @return rootNode
 */
- (WCGroupModel *)allSharedContactGroupModel;


/**
 *  取得帳號列表(樹狀)
 *
 *  @param error 回傳錯誤
 *
 *  @return 帳號列表
 */
- (NSMutableArray *)accountTreeListWithError:(NSError **)error;

/**
 *  取得指定帳號下的類別(樹狀)
 *
 *  @param accountGuid 指定帳號guid
 *  @param error 回傳錯誤
 *
 *  @return 帳號列表
 */
- (NSMutableArray *)groupArrayWithAccountGuid:(NSString *)accountGuid error:(NSError**)error;

/**
 *  取某帳號下，類別的分享名片數
 *
 *  @param categoryGuids 要取得的類別guid
 *  @param ownerGuid 類別擁有者
 *  @param error 回傳錯誤
*
 *  @return 帳號列表
 */
- (NSDictionary <NSString*, NSNumber *> *)sharedContactNumberWithCategoryGuids:(NSArray <NSString *>*)categoryGuids ownerGuid:(NSString *)ownerGuid error:(NSError **)error;


/**
 *  目前是否簡易UI模式(帳號列表不顯示名片數)
 *
 *  @param error 回傳錯誤
 *
 *  @return 帳號列表
 */
- (BOOL)shouldShowSimplifyUIWithError:(NSError **)error;

/**
 *  取某帳號下共分享幾筆給ownerGuid
 *
 *  @param ownerGuid 類別擁有者
 *  @param error 回傳錯誤
 *
 *  @return 帳號列表
 */
- (NSInteger)sharedContactNumberWithOwnerGuid:(NSString *)ownerGuid error:(NSError **)error;

@end
