//
//  ASVCAccountSelectModel.h
//  Pods
//
//  Created by AndrewLai on 2016/4/21.
//
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, ASVCAccountSelectModel_AccountRole)
{
    ASVCAccountSelectModel_AccountRole_Boss = 1,
    ASVCAccountSelectModel_AccountRole_Owner,
    ASVCAccountSelectModel_AccountRole_Normal
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ASVCAccountSelectModel Interface

@interface ASVCAccountSelectModel : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) ASVCAccountSelectModel_AccountRole accountRole;
@property (nonatomic, assign) BOOL       isSelected;
@property (nonatomic, assign) NSUInteger shareContactCount;//使用於切換檢視帳號

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (ASVCAccountSelectModel *)accountSelectModelWithAccountRole:(ASVCAccountSelectModel_AccountRole)accountRole
                                            shareContactCount:(NSUInteger)shareContactCount
                                                   isSelected:(BOOL)isSelected;

@end
