//
//  WCRecognitionPreferenceController.h
//
//  Created by Howard.Lin on 13/12/4.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPCountryCodeConvert.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static const NSInteger WCRC_UnsetIntValue = -99;

//WCM 6.0.0 新增 辨識名片時是否要自動填上國碼
//static NSString *const WCRC_IV_kRecognPhoneCountryCode = @"WCSC_IV_kRecognPhoneCountryCode";
static NSString *const WCRC_Settings_RecogLangOrder    = @"WCRC_Settings_RecogLangOrder";

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCRecognitionKernelVersion)
{
    WCRecognitionKernelVersion_None = 0,
    WCRecognitionKernelVersion_East,    // 東方語系
    WCRecognitionKernelVersion_West,    // 西方語系
    WCRecognitionKernelVersion_All,     // 全語系
};
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCRecognitionPreferenceController : NSObject
{
    @protected
     NSUserDefaults	*settings_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance methods

- (NSInteger)integerValueWithKey:(NSString *)key; // must overwrite

- (void)setIntegerValue:(NSInteger)value withKey:(NSString *)key;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (NSMutableArray *)copyKernelClipRecogTypeArray;

+ (NSMutableArray *)copyKernelRecogLangArrayWithSystemLanguage;

+ (NSMutableArray *)copyKernelRecogLangArrayWithKernelVersion:(WCRecognitionKernelVersion)kernelVersion;



/**
 * 把 recogLang 移到 recogLangArray 的最前面
 * @param recogLang 要移到前面的語系，PPCountry_Code
 * @param recogLangArray 目前支援語系列表
 */
+ (void)setFirstChoiceRecogLang:(NSInteger)recogLang inArray:(NSMutableArray *)recogLangArray;


/**
 * To get Country_Code
 * @return: Country_Code
 */
+ (PPCountry_Code)systemLanguage;

+ (NSString *)trimCompanyPrefix:(NSString *)oriCompanyName;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Accessory Class Methods

/**
 * Singleton pattern getter function
 */
+ (WCRecognitionPreferenceController *)shareWCRecognitionPreferenceController;


@end
