//
//  RecognitionOperation.h
//
//
//  Created by Howard.Lin on 13/12/4.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPIndexingController.h"
#import "WCCardModel.h"
#import "WCRecogSourceModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger const WCRO_MinMemorySize   = 10*1024*1024;
static NSUInteger const WCRO_MemoryCheckLoop = 10;

////////////////////////////////////////////////////////////////////////////////////////////////

// notification definition
static NSString* const WCRO_NOTIFY_OperationBegin   = @"WCRO_NOTIFY_OperationBegin";
static NSString* const WCRO_NOTIFY_OperationEnd     = @"WCRO_NOTIFY_OperationEnd";
static NSString* const WCRO_NOTIFY_UserInfo_kThread = @"WCRO_NOTIFY_UserInfo_kThread";            // value : thread

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, RecognitionOperationMode)
{
    RecognitionOperationMode_None = 0,
    RecognitionOperationMode_Normal, //單張辨識 (含正反面)
    RecognitionOperationMode_Silent, //背景辨識(多張)
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol RecognitionOperationDelegate <NSObject>

- (WCCardModel *)cardModelWithRecogImage:(UIImage *)recogImage
                             recogSource:(WCRecogSourceModel *)recogSource
                                   error:(NSError **)error;

@optional
- (void)wcroWillStartRecogWithMode:(RecognitionOperationMode)recogMode totalSource:(NSInteger)totalSource;
- (UIImage *)wcroResetImageBeforeRecognizing:(UIImage *)image recogSource:(WCRecogSourceModel *)recogSource;
- (UIImage *)wcroResetImageBeforeSaving:(UIImage *)image recogSource:(WCRecogSourceModel *)recogSource;
- (void)wcroRecogOneSource:(WCRecogSourceModel *)recogSource
                recogImage:(UIImage *)recogImage
ppRecognitionOperationMode:(RecognitionOperationMode)recognitionOperationMode
                 cardModel:(WCCardModel *)cardModel
                 restCount:(NSInteger)restCount
                     error:(NSError *)error;

- (void)wcroDidFinishRecogWithMode:(RecognitionOperationMode)recogMode;



@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface RecognitionOperation : NSOperation
{
    @protected
     id<RecognitionOperationDelegate> delegate_;
     NSError                            *lastError_;
     NSMutableArray                     *recogSourceArray_;
    
     PPIndexingStyle                    ppIndexStyle_;
     RecognitionOperationMode          recognitionOpertaionMode_;
}
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (atomic,assign) id<RecognitionOperationDelegate> delegate;
@property (assign) BOOL                               suspended;
@property (retain) NSError                            *lastError;
@property (retain) NSMutableArray                     *recogSourceArray;
@property (assign) PPIndexingStyle                    ppIndexStyle;
@property (assign) RecognitionOperationMode         recognitionOpertaionMode;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

- (id)initWithDelegate:(id)delegate recogSources:(NSMutableArray *)recogSourceArray;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class methods

+ (NSInteger)cardCountInRecogSourceArray:(NSArray *)recogSourceArray withStartIndex:(NSInteger)startIndex;

@end
