//
//  NCFCBaseFlowController+Private.h
//
//  NOTE
//  --------------------------------------------------
//  1. 所有可以繼承的、僅供內部使用的property/method放在這裡。
//  2. 負責轉發delegate
//

#import <Foundation/Foundation.h>

// Define
#import "ContactDataExchangeProtocol.h"
#import "WCNewCardFlowDelegate.h"

// Model
#import "WCABCardModel.h"

// View
#import "PPAlertView.h"

// Controller
#import "NCFCBaseFlowController.h"
#import "CardRecognitionController.h"
#import "WCContactEditViewController.h"
#import "WCImageBrowseViewController.h"
#import "WCContactAccessFlowController.h"

// Category
#import "WCNewCardFlowController+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef void (^AlertBlock)(BOOL didSubscribeNow);

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCBaseFlowController (Private) <
UIAlertViewDelegate,
CardRecognitionControllerDelegate,
WCContactAccessFlowControllerDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Property

@property (nonatomic, copy)    AlertBlock                     alertComplete;
@property (nonatomic, retain)  NSMutableArray                *recogSourceModels;
@property (nonatomic, retain)  NSArray                       *recogLangModels;
@property (nonatomic, assign)  BOOL                          addFrontCard;
/// 是否參考設定顯示辨識後流程
@property (nonatomic, assign)  BOOL                          adjustFlowBySettings;
@property (nonatomic, retain)  WCContactAccessFlowController *contactAccessFlowController;
@property (nonatomic, retain)  UIImage                       *headImage;
@property (nonatomic, retain)  UIImage                       *frontCardImage;
@property (nonatomic, retain)  UIImage                       *rearCardImage;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Method

- (WCDisplayNameOrder)requestDisplayNameOrderWithEasternName:(BOOL)easterName;

/// show alert
- (void)showAlertWithError:(NSError *)error title:(NSString *)title completion:(AlertBlock)completion;
- (void)showAgainRecogtionAlert;
                                               
- (BOOL)canNewCardWithError:(NSError **)error;

- (BOOL)requestShowWithError:(NSError *)error;
- (NSString *)requestMessageWithError:(NSError *)error;
- (NSString*)requestSpecificString;

- (void)requestRecogTaskAtIndex:(NSUInteger)index totalCount:(NSUInteger)totalCount;

- (WCCardModel *)requestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                       error:(NSError **)error;

- (WCCardModel *)requestRecogWithQRCodeString:(NSString *)qrCodeString
                                  newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                        error:(NSError **)error;

- (WCCardModel *)requestRecogWithSourceString:(NSString *)sourceString
                                  newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                        error:(NSError **)error;

- (WCCardModel *)requestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                       image:(UIImage *)image
                                       error:(NSError **)error;

- (WCCardModel *)requestClipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                               originalCardModel:(WCCardModel *)originalCardModel
                                           error:(NSError **)error;

- (NSArray *)requestCardModelWithCardModelDefaultGroupIDArray;

- (NSMutableArray *)requestCardModelWithAllGroupModelsWithCardID:(NSString *)cardID;

- (NSString *)requestCardModelWithGroupNamesWithGroupIDArray:(NSArray *)groupIDArray;

- (BOOL)requestCardModelWithExistGroupNamed:(NSString *)groupNamed;

- (WCGroupModel *)requestCardModelWithGroupModelByNewGroupName:(NSString *)groupName error:(NSError **)error;

- (WCGroupModel *)requestCardModelWithGroupModelByExistGroupName:(NSString *)groupName;


- (void)requestRecogWithWithSourceModels:(NSMutableArray *)recogSourceModels;

// 多張通知
- (BOOL)requestSaveWithCardModel:(WCCardModel *)cardModel
                    idPhotoImage:(UIImage *)idPhotoImage
                  frontSideImage:(UIImage *)frontSideImage
                   backSideImage:(UIImage *)backSideImage
                           error:(NSError **)error;

// 單張通知
- (BOOL)requestSaveWithSingleCardModel:(WCCardModel *)cardModel
                          idPhotoImage:(UIImage *)idPhotoImage
                        frontSideImage:(UIImage *)frontSideImage
                         backSideImage:(UIImage *)backSideImage
                              sourceID:(NSString *)sourceID
                               groupID:(NSString *)groupID
                              personID:(NSString *)personID
                                 error:(NSError **)error;

- (BOOL)requestSaveWithWCABCardModel:(WCABCardModel *)cardModel
                               error:(NSError **)error;

- (void)requestShowPromotionFomrCaptureViewController:(WCCaptureViewController *)captureViewController;

- (void)requestDidSelectStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType;

- (NSArray *)requestDefaultSharedAccountGuidsWithCardID:(NSString *)cardID;

- (NSMutableArray *)requestSpaceTypeArray;

- (void)didFinishWithError:(NSError *)lastError;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Save Image Method

- (NSString *)pathForSavingImage:(UIImage *)image
                         imageID:(NSString *)imageID
                       imageType:(WC_ImageType)imageType
                     lightEnable:(BOOL)lightEnable;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance RecogSourceModel Method

- (WCRecogSourceModel *)nextRecogSourceModelWithCardID:(NSString *)cardID
                                             imageType:(WC_ImageType)imageType
                                               addMode:(WCRecogSourceModelAddMode)addMode;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance ContactEditViewController Method

- (BOOL)showContactEditViewControllerWithCardModel:(WCCardModel *)cardModel
                                      idPhotoImage:(UIImage *)idPhotoImage
                                    frontCardImage:(UIImage *)frontCardImage
                                     rearCardImage:(UIImage *)rearCardImage;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Recognition Method

- (NSString *)recogTitleWithRecogLangCode:(NSUInteger)recogLangCode;

- (NSUInteger)requestRecogLangCodeWithRecogLangauge:(NSString *)recogTitle;

- (NSArray *)recogLangTitlesWithSelectedTitle:(NSString *)selectedTitle;

- (void)prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:(WCNewCardFlowControllerAddCardMode)addCardMode
                                                  fromViewController:(UIViewController *)viewController;

- (NSUInteger)numberOfWholeCard;

@end
