//
//  WCMapViewController.h
//
//  使用須知: info.plist 要註冊 NSLocationWhenInUseUsageDescription, LSApplicationQueriesSchemes: @[comgooglemaps-x-callback, baidumap]
//
//  Created by Howard on 2015/12/29.
//
//

#import "PPViewController.h"
#import <MapKit/MapKit.h>

// Define
#import "WCMapViewController+ParameterDefine.h"
#import "WCMapViewControllerDatasource.h"
#import "WCMapViewControllerDelegate.h"
#import "WCMapPinAnnotationViewDatasource.h"
#import "WCMapPinAnnotationViewDelegate.h"

@interface WCMapViewController : PPViewController <WCMapPinAnnotationViewDatasource,WCMapPinAnnotationViewDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<WCMapViewControllerDatasource> datasource;
@property (nonatomic,assign) id<WCMapViewControllerDelegate> delegate;

@property (nonatomic,assign) CGFloat                 maximumDistanceKiloMeterThreshold;  //預設顯示最大距離,CGFLOAT_MAX
@property (nonatomic,assign) CGFloat                 mapCenterDistanceKiloMeterThreshold;  //DefaultMapCenterDistanceKiloMeterThreshold (300),目前位置，與上次手機位置相差300公尺,移動一次地圖頁面
@property (nonatomic,retain) CLLocation              *myLocation; //目前位置，會設定成地圖的中心
@property (nonatomic,assign) CGSize                  mapRegionSize; // default (1000,1000) 單位公尺
@property (nonatomic,assign) CGFloat                 defaultClusterPixel; //default 0, 代表除非在一點上，不然不會合併
@property (nonatomic,copy)   NSString                *focusCardID; //目前 focusCardID　內部使用
@property (nonatomic,retain) WCMapPinAnnotationView  *focusMapPinAnnotationView; //目前 focustMapPinAnnotationView 內部使用
@property (nonatomic,assign) WCMapViewControllerDistanceStyle mapViewControllerDistanceStyle;
@property (nonatomic,assign) NSUInteger              allowContiueTimeoutCount; // 允許的連續timeOut次數

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (void)checkAccessPermissionWithCompletion:(void (^)(BOOL authorized))completion;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)moveMapToLocation:(CLLocation *)location;
- (void)updateDistanceContactList;
- (void)moveToDistanceContactListFocusCardID:(NSString *)cardID;
- (void)mapViewDidZoomWithinMapRect:(MKMapRect)rect withZoomScale:(double)zoomScale;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Log methods

/// 啟動log
+ (void)logEnable:(BOOL)enable;

/// 取得log path
+ (NSString *)logDirPath;
@end
