//
//  WCImportFlowController.h
//  Pods
//
//  Created by Howard on 2015/8/6.
//
//

#import <Foundation/Foundation.h>

// Define
#import "WCImportFlowControllerDatasource.h"
#import "WCImportFlowControllerDelegate.h"
#import "PPStorageSpaceSelectViewController+PublicParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCImportFlowController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<WCImportFlowControllerDatasource> importFlowDatasource;
@property (nonatomic,assign) id<WCImportFlowControllerDelegate> importFlowDelegate;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  顯示空間選擇視圖
 *
 *  @param cloudKeyDictionary  空間設定鍵值辭典
 *  @param spaceTypeArray      空間選擇陣列 The array of PPStorageSpaceSelectControllerSpaceType
 *  @param superViewController 來源視圖
 *
 *  @return YES 成功顯示
 */
- (BOOL)showStorageSpaceViewControllerWithCloudKeyDictionary:(NSDictionary *)cloudKeyDictionary
                                              spaceTypeArray:(NSArray *)spaceTypeArray
                                         superViewController:(UIViewController *)superViewController;


/**
 *  顯示群組選擇畫面
 *
 *  @param superViewController 來源視圖
 *  @param fileListArray       匯入檔案列表 (The NSString of Array)
 *
 *  @return YES 成功顯示
 */
- (BOOL)showGroupViewControllerWithSuperViewController:(UIViewController *)superViewController
                                         fileListArray:(NSArray <NSString *> *)fileListArray;

@end
