//
//  WCGroupSelectorViewController.h
//  Pods
//
//  Created by Andrew on 2015/7/9.
//
//

#import "PPViewController.h"

#import "WCSingleLayerGroupViewController+SettingsKey.h"

// Model
#import "NSString+Additions.h"
#import "WCGroupModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCSingleLayerGroupViewControllerStyle)
{
    WCSingleLayerGroupViewControllerStyle_Edit=0,      ///<類別編輯
    WCSingleLayerGroupViewControllerStyle_ChangeGroup, ///<變更類別
    WCSingleLayerGroupViewControllerStyle_ChangeGroupWithoutAdd, ///<變更類別
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCSingleLayerGroupViewController;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCGroupSelectorViewController Protocol

@protocol WCSingleLayerGroupViewControllerDelegate <NSObject>

/**
 *  要求外部給予群組清單(WCGroupModel的Array, 無包含未分類)
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *
 *  @return 所有的群組清單
 */
- (NSMutableArray *)sourceGroupArrayForGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController;

#pragma mark - for group add

/**
 *  詢問group名稱是否已存在，不存在才可以新增
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *  @param groupNamed                  要詢問的群組名稱
 */
- (BOOL)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController isExistGroupNamed:(NSString*)groupNamed;

/**
 *  新增按下確定後，通知要新增群組，並回傳新增後的群組資訊
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *  @param groupName                   新增的群組名稱
 */
- (WCGroupModel *)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController groupModelByNewGroupName:(NSString *)groupName;

@optional
#pragma mark - for group change style

/**
 *  要求外部給予已選擇的群組清單(WCGroupModel的Array, 未分類直接傳nil)
 *
 *  @param singleLayerGroupViewController groupSelectorViewController
 *
 *  @return 已選擇的群組清單
 */
- (NSArray *)selectedGroupArrayForGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController;


/**
 *  點下完成時，通知選擇了哪些群組(WCGroupModel的Array, 未分類直接回傳nil)
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *  @param groupArray                  選擇的群組清單
 */
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController groupsDidSelected:(NSArray *)groupArray;


#pragma mark - for group edit style


/**
 *  點下新增
 *  Note, 取消不會進來
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 */
- (void)didClickNewGroupWithViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController;

/**
 * 通知順序改變
 * @param singleLayerGroupViewController singleLayerGroupViewController
 * @return BOOL YES，if success, else NO
 */
- (BOOL)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController  didOrderChangedWithNewGroupArray:(NSArray *)groupArray;

/**
 * 重新排序群組
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 * @param currentGroups 目前的群組
 * @return NSArray 回傳排序後的群組，排序方式用Ap決定
 */
- (NSMutableArray*)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController sortedGroupWithCurrentGroups:(NSArray *)currentGroups;

/**
 *  編輯按下確定後，通知要更新群組
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *  @param groupModel                  要更新的群組
 */
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController updateGroupModel:(WCGroupModel *)groupModel;

/**
 *  按下刪除後，通知要刪除群組
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *  @param groupModel                  要刪除的群組
 */
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController deleteGroupModel:(WCGroupModel *)groupModel;

/**
 *  點下完成時, 通知群組順序，因為有可能有刪除，所以依回傳的group array順序重排
 *
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 *  @param groupModelArray             結束後最終的情況
 */
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController didEditFinishWithGroupArray:(NSArray *)groupModelArray;

/**
 *  點下完成, 處理完所有動作後，通知app
 *  Note, 取消不會進來
 *  @param singleLayerGroupViewController singleLayerGroupViewController
 */
- (void)didFinishSingleGroupGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController;


@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCGroupSelectorViewController Interface

@interface WCSingleLayerGroupViewController : PPViewController

@property (nonatomic, assign) id<WCSingleLayerGroupViewControllerDelegate> delegate;

/// 顯示的模式，預設是WCGroupSelectorViewControllerStyle_Edit，也就是group編輯
@property (nonatomic, assign) WCSingleLayerGroupViewControllerStyle        style;
@property (nonatomic, retain) id                                        userInfo;
@property (nonatomic, retain) NSString *titleString;
@property (nonatomic, retain) NSString *noResultString;     /// < 沒有任何群組時的顯示字串，default nil, 不顯示
@property (nonatomic, assign) NSInteger maxGroupLength;     /// < 群組名稱最大長度，default 0表示不限制
@property (nonatomic, assign) BOOL clickCellToEdit;         /// < 點選cell後是否要進入編輯群組名稱的模式，預設YES
@property (nonatomic, assign) BOOL showSortButton;         /// < 是否顯示預設排序按鈕，預設YES
@property (nonatomic, assign) BOOL forWCTMode;              /// < 是否是WCT用的，預設NO，如果是的話，All, other 也可以刪除，且刪除後不會顯示Tip


/// 顯示新增群組介面
- (void)showNewGroupUI;

- (void)clearAndLoadGroupData;

@end
