//
//  WCGroupAccessFlowControllerDelegate.h
//  ADAL
//
//  Created by sanhue on 2018/3/8.
//

#import <Foundation/Foundation.h>
#import "WCSingleLayerGroupViewController.h"

@class WCGroupAccessFlowController;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCGroupAccessFlowController Protocol

@protocol WCGroupAccessFlowControllerDelegate <NSObject>

/**
 *  要求外部給予群組清單(WCGroupModel的Array, 無包含未分類)
 *
 *  @param groupAccessFlowController instance of flowController
 *  @param error 回傳錯誤
 *  @return 所有的群組清單
 */
- (NSMutableArray *)sourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController error:(NSError **)error;

@optional

#pragma mark - error message handler
/**
 * 客制化錯誤
 * @param groupAccessFlowController instance of flowController
 * @param error 目前錯誤
 * @return 要顯示的錯誤字串，沒有要客制化則回傳nil，會顯示預設錯誤訊息
 */
- (NSString *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestErrorMessageForError:(NSError *)error;

#pragma mark - for group add

/**
 *  詢問group名稱是否已存在，不存在才可以新增
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param groupNamed                  要詢問的群組名稱
 */
- (BOOL)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestIsExistGroupNamed:(NSString*)groupNamed;

/**
 *  新增按下確定後，通知要新增群組，並回傳新增後的群組資訊
 *
 *  @param groupAccessFlowController    groupAccessFlowController
 *  @param groupName                    新增的群組名稱
 *  @param superGroupGuid               新增群組的superGuid
 *  @param error                        取得回傳的錯誤
 */
- (WCGroupModel *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController
            requestGroupModelByNewGroupName:(NSString *)groupName
                             superGroupGuid:(NSString *)superGroupGuid
                                      error:(NSError **)error;


#pragma mark - for group change style

/**
 *  要求外部給予已選擇的群組清單(WCGroupModel的Array, 未分類直接傳nil)
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param error 回傳錯誤
 *
 *  @return 已選擇的群組清單
 */
- (NSArray *)selectedGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController error:(NSError **)error;


/**
 *  點下完成時，通知選擇了哪些群組(WCGroupModel的Array, 未分類直接回傳nil)
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param groupArray                  選擇的群組清單, 未分類直接回傳nil
 */
- (void)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController groupsDidSelected:(NSArray *)groupArray;


#pragma mark - for group edit style

/**
 * 重新排序群組
 * @param groupAccessFlowController groupAccessFlowController
 * @param currentGroups 目前的群組
 *
 * @return NSArray 回傳排序後的群組，排序方式用Ap決定
 */
- (NSMutableArray*)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController sortedGroupWithCurrentGroups:(NSArray *)currentGroups;

/**
 *  編輯按下確定後，通知要更新群組
 *
 * @param groupAccessFlowController groupAccessFlowController
 *  @param groupModel                  要更新的群組
 */
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController updateGroupModel:(WCGroupModel *)groupModel;

/**
 *  按下刪除後，通知要刪除群組
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param groupModel                  要刪除的群組
 */
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController deleteGroupModel:(WCGroupModel *)groupModel;


/**
 *  點下完成時, 通知群組順序，因為有可能有刪除，所以依回傳的group array順序重排
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param groupModelArray             結束後最終的情況
 */
- (void)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController didEditFinishWithGroupArray:(NSArray *)groupModelArray;

#pragma mark - for pinned group methods


/**
 *  要求外部釘選給予群組清單(WCGroupModel的Array, 包含未分類)
 *
 *  @param groupAccessFlowController instance of flowController
 *
 *  @return 完整的類別樹
 */
- (NSMutableArray *)pinnedSourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController;


/**
 *  新增按下確定後，通知要釘選或是取消釘選群組，並回傳新增後的群組資訊
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param groupModels               要設定的群組
 *  @param pinned                    釘選或是取消釘選
 */
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestGroupModels:(NSArray <WCGroupModel *>*)groupModels pinned:(BOOL)pinned;


#pragma mark - for move tree group methods


/**
 *  取得可移動的類別樹
 *
 *  @param groupModel 準備要移動的類別
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param error 回傳錯誤
 *  @return 可移動的類別樹
*/
- (NSArray *)validParentsForMoveGroupModel:(WCGroupModel *)groupModel withGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController error:(NSError **)error;

/**
 *  移動類別
 *
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param groupModel 準備要移動的類別
 *  @param parentGuid 要移動到哪一個類別
 *  @return 回傳錯誤
 */
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController moveGroupModel:(WCGroupModel *)groupModel toParentGuid:(NSString *)parentGuid;

/**
 * 通知釘選類別順序改變
 * @param groupAccessFlowController groupAccessFlowController
 * @param singleLayerGroupViewController singleLayerGroupViewController
 * @return BOOL YES，if success, else NO
 */
- (BOOL)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController didOrderChangedWithNewGroupArray:(NSArray *)groupArray;

#pragma mark - for group flow end

/**
 *  點下完成, 處理完所有動作後，通知app
 *  Note, 取消不會進來
 *  @param groupAccessFlowController groupAccessFlowController
 *  @param viewController view controller that end flow
 */
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController didFinishViewController:(UIViewController *)viewController;
//- (void)didFinishSingleLayerGroupViewController:(WCSingleLayerGroupViewController*)groupViewController;
@end
