//
//  WCFileTypeSelectView.h
//  Pods
//
//  Created by Andrew on 2015/7/30.
//
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCFileTypeSelectView_ContactFileType)
{
    WCFileTypeSelectView_ContactFileType_None        = 0,
    WCFileTypeSelectView_ContactFileType_WCXF        = 1 << 0,
    WCFileTypeSelectView_ContactFileType_CSV_Outlook = 1 << 1,
    WCFileTypeSelectView_ContactFileType_CSV_Gmail   = 1 << 2,
    WCFileTypeSelectView_ContactFileType_VCF         = 1 << 3,
    WCFileTypeSelectView_ContactFileType_Image       = 1 << 4,
    WCFileTypeSelectView_ContactFileType_Text        = 1 << 5,
    WCFileTypeSelectView_ContactFileType_XLSX        = 1 << 6,
    WCFileTypeSelectView_ContactFileType_CSV_iWorks  = 1 << 7
};

typedef NS_ENUM(NSUInteger, WCFileTypeSelectView_FileTypeTextInfo)
{
    WCFileTypeSelectView_FileTypeTextInfo_None        = 0,
    WCFileTypeSelectView_FileTypeTextInfo_Name        = 1 << 0,
    WCFileTypeSelectView_FileTypeTextInfo_CompanyInfo = 1 << 1,
    WCFileTypeSelectView_FileTypeTextInfo_Phone       = 1 << 2,
    WCFileTypeSelectView_FileTypeTextInfo_Address     = 1 << 3,
    WCFileTypeSelectView_FileTypeTextInfo_Email       = 1 << 4,
    WCFileTypeSelectView_FileTypeTextInfo_URL         = 1 << 5,
    WCFileTypeSelectView_FileTypeTextInfo_IM          = 1 << 6,
    WCFileTypeSelectView_FileTypeTextInfo_All         = ((1 << 7)-1)
};

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger WCFileTypeSelectView_fileTypeAbbreviationFontSize     = 16;
static NSUInteger WCFileTypeSelectView_fileTypeFullNameFontSize         = 14;
static NSUInteger WCFileTypeSelectView_fileTypeFullNameCommentFontSize  = 11;

static NSString *const WCFileTypeSelectView_fileTypeAbbreviation_XLSX   = @"XLSX";
static NSString *const WCFileTypeSelectView_fileTypeAbbreviation_WCXF   = @"WCXF";
static NSString *const WCFileTypeSelectView_fileTypeAbbreviation_CSV    = @"CSV";
static NSString *const WCFileTypeSelectView_fileTypeAbbreviation_VCF    = @"VCF";
static NSString *const WCFileTypeSelectView_fileTypeAbbreviation_Image  = @"JPG";
static NSString *const WCFileTypeSelectView_fileTypeAbbreviation_Text   = @"TXT";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCFileTypeSelectView Protocol

@class WCFileTypeSelectView;
@protocol WCFileTypeSelectViewDelegate <NSObject>

@optional
/**
 *  告知目前選取的檔案格式
 *
 *  @param fileTypeSelectView fileTypeSelectView
 *  @param contactFileType contactFileType
 */
- (void)fileTypeSelectView:(WCFileTypeSelectView *)fileTypeSelectView didSelectContactFileType:(WCFileTypeSelectView_ContactFileType)contactFileType;


/**
 *  告知取消選取的檔案格式
 *
 *  @param fileTypeSelectView fileTypeSelectView
 *  @param contactFileType  contactFileType
 */
- (void)fileTypeSelectView:(WCFileTypeSelectView *)fileTypeSelectView didDeselectContactFileType:(WCFileTypeSelectView_ContactFileType)contactFileType;


/**
 *  告知目前勾選的聯絡人欄位資訊
 *
 *  @param fileTypeSelectView fileTypeSelectView
 *  @param fileTypeTextInfo   fileTypeTextInfo
 */
- (void)fileTypeSelectView:(WCFileTypeSelectView *)fileTypeSelectView didSelectFileTypeTextInfo:(WCFileTypeSelectView_FileTypeTextInfo)fileTypeTextInfo;


/**
 *  告知取消勾選的聯絡人欄位資訊
 *
 *  @param fileTypeSelectView fileTypeSelectView
 *  @param fileTypeTextInfo   fileTypeTextInfo
 */
- (void)fileTypeSelectView:(WCFileTypeSelectView *)fileTypeSelectView didDeselectFileTypeTextInfo:(WCFileTypeSelectView_FileTypeTextInfo)fileTypeTextInfo;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCFileTypeSelectView Interface

@interface WCFileTypeSelectView : UIView

@property (nonatomic, assign) id<WCFileTypeSelectViewDelegate>        delegate;
//default is (WCXF/CSV/VCF/Image), WCFileTypeSelectView_ContactFileType的NSNumber物件所組成的陣列(擺放順序等於介面由上至下呈現順序)
@property (nonatomic, retain) NSArray                                *supportFileTypes;
//default is None, 可設定已選擇的檔案格式(單選)
@property (nonatomic, assign) WCFileTypeSelectView_ContactFileType    contactFileTypeSelected;
//default is All, 若fileType為Text時，可以透過此property取得目前勾選的Info(複選會使用OR統整一起)
@property (nonatomic, assign) WCFileTypeSelectView_FileTypeTextInfo fileTypeTextInfoSelected;

//檔案格式選擇上方的文字敘述
@property (nonatomic, retain) NSString                               *fileTypeSelectorTitle;
// 檔案格式為Text時，顯示於infoCheckBoxGroup上方的Title
@property (nonatomic, retain) NSString                               *textInfoCheckBoxTitle;

//提供(暫無使用ios 8.1丟tableView會有問題，丟入footerView後續無資料的cell就不會呈現)
@property (nonatomic, retain) UIView                                 *selectFooterView;

//因為要設定sectionTitle上顯示的顏色，相關所需設定太多，所以獨立一個參數
@property (nonatomic, retain) UIColor                                *tableSectionColor;

@end
