
//  WCDataControllerProtocol.h
//  Pods
//
//  Created by sanhue on 2016/7/22.
//
//

#import <Foundation/Foundation.h>
#import "WCImageDefine.h"
#import "WCGroupDefine.h"
#import "WCFieldDefine.h"
#import "WCSyncTargetDefine.h"
#import "WCDisplayRuleDefine.h"
#import <AddressBook/AddressBook.h>
#import "CrossPlatformDefine.h"
#import "WCCustomFieldInfo.h"

// !!  為了避免與WCDataModel/Model有相依性，所以這邊用@class來定義model
@class WCCardStreamModel;
@class WCGroupModel;
@class WCCardModel;
@class WCABCardModel;


////////////////////////////////////////////////////////////////////////////////////////////////////
// API 中用到的 block

typedef void (^LoadCardSectionCompletion)(NSError *error);



////////////////////////////////////////////////////////////////////////////////////////////////////
// API 中用到的 ENUM
typedef NS_ENUM(NSInteger, WCDC_AccessMode)
{
    WCDC_AM_Text	= 0x01,
    WCDC_AM_Image	= 0x01 << 1,
    WCDC_AM_All		= WCDC_AM_Text | WCDC_AM_Image,
};

typedef NS_OPTIONS(NSInteger, WCM_DBWithAppVersion)
{
    WCM_v400,
    WCHD_V124,
    WCM_v500,
    WCM_v520_WCHD_v206,
    WCM_v600_WCHD_v300,
    WCM_v620_WCHD_v320,//WCM 6.2.0新增,用來判斷資料庫是否為620版本
    WCM_v700,
    WCM_v732_WCHD_v400, 
    WCM_noDB
};

typedef NS_ENUM(NSInteger, WCDC_NotifyChangeType)
{
    WCDC_NCT_Add = 0,
    WCDC_NCT_Delete,
    WCDC_NCT_Update
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Notification

// 顯示資料改變
#define WCDC_NOTIFY_DisplayDataChanged          @"WCDC_NOTIFY_DisplayDataChanged"
#define WCDC_NOTIFY_UserInfo_kAddCard           @"WCDC_NOTIFY_UserInfo_kAddCard"            // value : cardIDArray
#define WCDC_NOTIFY_UserInfo_kRemoveCard        @"WCDC_NOTIFY_UserInfo_kRemoveCard"         // value : cardIDArray
#define WCDC_NOTIFY_UserInfo_kUpdateCard        @"WCDC_NOTIFY_UserInfo_kUpdateCard"         // value : cardIDArray
#define WCDC_NOTIFY_UserInfo_kUpdatedCardGroup  @"WCDC_NOTIFY_UserInfo_kUpdatedCardGroup"   // value : groupIDArray

// 影像變更
#define WCDC_NOTIFY_DisplayImageChanged         @"WCDC_NOTIFY_DisplayImageChanged"
#define WCDC_NOTIFY_UserInfo_kChangeType        @"WCDC_NOTIFY_UserInfo_kChangeType"         // value : WCDC_NotifyChangeType (NSNumber)
#define WCDC_NOTIFY_UserInfo_kImageType         @"WCDC_NOTIFY_UserInfo_kImageType"          // value : WC_ImageType (NSNumber)
#define WCDC_NOTIFY_UserInfo_kCardID            @"WCDC_NOTIFY_UserInfo_kCardID"             // value : cardID (NSString)

// 群組資料改變
#define WCDC_NOTIFY_GroupAdd                    @"WCDC_NOTIFY_GroupAdd"
#define WCDC_NOTIFY_GroupNameChanged            @"WCDC_NOTIFY_GroupNameChanged"
#define WCDC_NOTIFY_GroupRemoved                @"WCDC_NOTIFY_GroupRemoved"
#define WCDC_NOTIFY_UserInfo_kGroupID           @"WCDC_NOTIFY_UserInfo_kGroupID"            // value : groupID (NSNumber)

// Load  card secion
#define WCDC_NOTIFY_LoadCardSectionsResult      @"WCDC_NOTIFY_LoadCardSectionsResult"
#define WCDC_NOTIFY_UserInfo_kResult            @"WCDC_NOTIFY_UserInfo_kResult"             // value : YES or NO
#define WCDC_NOTIFY_UserInfo_kError             @"WCDC_NOTIFY_UserInfo_kError"              // value : NSError

#define WCDC_NOTIFY_MoveCardProgress            @"WCDC_NOTIFY_MoveCardProgress"
#define WCDC_NOTIFY_UserInfo_kPercentage        @"WCDC_NOTIFY_UserInfo_kPercentage"         // value : float (0.0 ~ 1.0)



/// load favorite result
#define WCDC_NOTIFY_LoadFavoritesResult         @"WCDC_NOTIFY_LoadFavoritesResult"

#define WCDC_NOTIFY_FavoriteChanged             @"WCDC_NOTIFY_FavoriteChanged"
#define WCDC_NOTIFY_UserInfo_kAddFavorite       @"WCDC_NOTIFY_UserInfo_kAddFavorite"        // value : cardIDArray
#define WCDC_NOTIFY_UserInfo_kRemoveFavorite    @"WCDC_NOTIFY_UserInfo_kRemoveFavorite"     // value : cardIDArray
#define WCDC_NOTIFY_UserInfo_kUpdateFavorite    @"WCDC_NOTIFY_UserInfo_kUpdateFavorite"     // value : cardIDArray

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol WCDataControllerProtocol_Init;
@protocol WCDataControllerProtocol_Error;
@protocol WCDataControllerProtocol_Image;
@protocol WCDataControllerProtocol_Favorites;
@protocol WCDataControllerProtocol_Unverified;
@protocol WCDataControllerProtocol_CustomFieldInfo;
@protocol WCDataControllerProtocol_Group;
@protocol WCDataControllerProtocol_CardGroup;
@protocol WCDataControllerProtocol_Card;
@protocol WCDataControllerProtocol_WCABCardModel;
@protocol WCDataControllerProtocol_AddressBookConvertToContacts;
@protocol WCDataControllerProtocol_RecentContact;
@protocol WCDataControllerProtocol_Import;
@protocol WCDataControllerProtocol_Section;
@protocol WCDataControllerProtocol_DisplayRule ;
@protocol WCDataControllerProtocol_Duplicate;
@protocol WCDataControllerProtocol_Unrecognized;
@protocol WCDataControllerProtocol_Reminder;
@protocol WCDataControllerProtocol_Utility;
@protocol WCDataControllerProtocol_Notify;
@protocol WCDataControllerProtocol_WCMSync;
@protocol WCDataControllerOverrideProtocol;

////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol WCDataControllerProtocol
<
WCDataControllerProtocol_Init,
WCDataControllerProtocol_Error,
WCDataControllerProtocol_Image,
WCDataControllerProtocol_Favorites,
WCDataControllerProtocol_Unverified,
WCDataControllerProtocol_CustomFieldInfo,
WCDataControllerProtocol_Group,
WCDataControllerProtocol_CardGroup,
WCDataControllerProtocol_Card,
WCDataControllerProtocol_WCABCardModel,
WCDataControllerProtocol_AddressBookConvertToContacts,
WCDataControllerProtocol_RecentContact,
WCDataControllerProtocol_Import,
WCDataControllerProtocol_Section,
WCDataControllerProtocol_DisplayRule ,
WCDataControllerProtocol_Duplicate,
WCDataControllerProtocol_Unrecognized,
WCDataControllerProtocol_Reminder,
WCDataControllerProtocol_Utility,
WCDataControllerProtocol_Notify,
WCDataControllerProtocol_WCMSync
>

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init

@protocol WCDataControllerProtocol_Init <NSObject>

// general use
- (instancetype)initWithAccessMode:(WCDC_AccessMode)accessMode;

@optional

// for parsing backup data
- (instancetype)initWithBaseDirPath:(NSString *)baseDirPath;

// for parsing converter
- (instancetype)initWithBaseDirPath:(NSString *)baseDirPath withoutGroup:(BOOL)withoutGroup;

// raw initialize method
- (instancetype)initWithAccessMode:(WCDC_AccessMode)accessMode
                       baseDirPath:(NSString *)baseDirPath
               useSharedDBInstance:(BOOL)useSharedDBInstance
                      isExistingDB:(BOOL)isExistingDB;

@end

@protocol WCDataControllerProtocol_Error <NSObject>

- (NSError *)lastError;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Image methods

@protocol WCDataControllerProtocol_Image <NSObject>

// 檢查是否有名片圖
- (BOOL)hasCardImageWithCardID:(NSString *)cardID type:(WC_ImageType)type;

// 取得名片圖檔案路徑
- (NSString *)cardImagePathWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// 取得假名片圖
// return : CPImage (release after using)
- (CPImage *)copyVirtualCardImageWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// 取得名片圖 （沒有影像時會直接回傳假名片圖, 如果是縮圖，會以cache中的圖優先
// return : CPImage (release after using)
- (CPImage *)copyCardImageWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// 取得名片圖資料 (直接從檔案讀取)
// return : NSData (release after using)
- (NSData *)copyCardImageDataWithCardID:(NSString *)cardID type:(WC_ImageType)type subtype:(WC_ImageSubType)subtype;

// 設定名片圖
- (BOOL)setCardImage:(CPImage *)image withCardID:(NSString *)cardID type:(WC_ImageType)type;

// 設定名片圖, isImport==YES時不會修改modify time,與送出通知
- (BOOL)setCardImage:(CPImage *)image withCardID:(NSString *)cardID type:(WC_ImageType)type isImport:(BOOL)isImport;

// 設定名片圖資料
- (BOOL)setCardImageData:(NSData *)imageData withCardID:(NSString *)cardID type:(WC_ImageType)type;

// 設定名片圖資料
- (BOOL)setCardImageData:(NSData *)imageData withCardID:(NSString *)cardID type:(WC_ImageType)type isImport:(BOOL)isImport;

// 刪除指定的名片圖, isImport==YES時不會修改modify time,與送出通知
- (void)removeCardImageWithCardID:(NSString *)cardID type:(WC_ImageType)type;

// 刪除一筆名片所有關聯的圖
- (void)removeAllCardImagesWithCardID:(NSString *)cardID;

/// (cached中)card holder list顯示圖片用的, 會先取大頭貼，再取名片圖
- (CPImage *)cachedDisplayCardImageWithCardID:(NSString *)cardID;

/// card holder list顯示圖片用的, 會先取大頭貼，再取名片圖
- (CPImage *)displayCardImageWithCardID:(NSString *)cardID;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Favorites methods

@protocol WCDataControllerProtocol_Favorites <NSObject>

// 讀取favorite, 會記在cache model中，再透過notify通知
- (void)loadFavoriteCardWithSearchText:(NSString *)searchText;

// 搜尋favorite
// return : array of WCCardModel (release after using)
- (NSMutableArray *)copyFavoritesWithSearchText:(NSString *)searchText;

// 是否設定為favorite
- (BOOL)isFavorite:(NSString *)cardID;

// 加入favorite
- (BOOL)addFavoriteWithCardID:(NSString *)cardID;

// 移除favorite
- (BOOL)removeFavoriteWithCardID:(NSString *)cardID;

// 變更favorite順序
- (BOOL)moveFavoriteWithCardID:(NSString *)cardID toOrder:(NSInteger)toOrder;

/// iOS版7.0 加入我的最愛的action Type
- (void)setActionType:(NSInteger)actionType withCardID:(NSString *)cardID;

/// iOS版7.0 取得我的最愛的action Type
- (NSInteger)actionTypeWithCardID:(NSString *)cardID;

/// macOS版4.0 取得我的最愛的數量
- (NSInteger)favoriteCount;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Unverified methods

@protocol WCDataControllerProtocol_Unverified <NSObject>

// 取得所有Unverified
// return : array of WCCardSectionModel (release after using)
- (NSMutableArray *)copyAllUnverifiedCardSection;

// 移除未分類
- (BOOL)removeUnverifiedWithCardID:(NSString *)cardID withNotification:(BOOL)isSendNotification;

/// ios版7.0 是否有未校正名片
- (BOOL)hasUnverified;

/// macOS版4.0 取得未校正數量
- (NSInteger)unverifiedCount;

// 是否為未校正
- (BOOL)isUnverifiedWithCardID:(NSString *)cardID;

@optional
/// 移除未分類, 可不更新dirty table
- (BOOL)removeUnverifiedWithCardID:(NSString *)cardID withNotification:(BOOL)isSendNotification updateCardSyncAction:(BOOL)updateCardSyncAction;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Custom field info

@protocol WCDataControllerProtocol_CustomFieldInfo <NSObject>

@optional
/**
 * 取得所有自訂欄位資料
 * @return NSMutableArray array of WCCustomFieldInfo
 */
- (NSMutableArray *)copyAllCustomFieldInfos;

/// 依自訂欄位guid, 取得自訂欄位資料
- (WCCustomFieldInfo *)customFieldInfoWithGuid:(NSString *)guid;

/// 新增一個自訂欄位資料
- (BOOL)addCustomFieldWithInfo:(WCCustomFieldInfo *)customFieldInfo;

/// 如果已存在，就更新，如果不存在就新增
- (BOOL)updateCustomFieldWithInfo:(WCCustomFieldInfo *)customFieldInfo;

/// 移除一個自訂欄位
- (void)removeCustomFieldWithGuid:(NSString *)guid;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Group methods

@protocol WCDataControllerProtocol_Group <NSObject>

/// 判斷群組名稱是否已經存在
- (BOOL)isGroupNameExist:(NSString *)groupName;

/**
 * 新增群組
 * @param groupName 群組名稱
 * @return WCGroupModel (release after using)
 */
- (WCGroupModel *)newGroupWithName:(NSString *)groupName;

/**
 * 更新群組順序
 * @param groupIDArray array of groupID in NSString format
 */
- (void)updateOrderWithGroupIDArray:(NSArray *)groupIDArray;

/**
 * 變更群組名稱
 * @param groupName 群組名稱
 * @param groupID groupID in NSString format
 * @return BOOL YES:成功；NO:失敗
 */
- (BOOL)updateGroupName:(NSString *)groupName withID:(NSString *)groupID;

/**
 * 刪除群組
 * @param groupID NSString 群組ID，WCM, WCT要把WC_GroupID轉成string後塞進來
 * @return BOOL YES:成功；NO:失敗
 */
- (BOOL)removeGroupWithID:(NSString *)groupID;

/**
 * 取得所有群組資料
 * @param getCardCount 是否需要取得名片數量
 * @return  array of WCGroupModel (release after using)
 */
- (NSMutableArray *)copyAllGroupsAndGetCardCount:(BOOL)getCardCount;

/**
 * 依groupName取得群組ID
 * @param groupName 群組名稱
 * @return NSString groupID in NSString format
 */
- (NSString *)groupIDWithName:(NSString *)groupName;

/**
 * 依groupID取得群組名稱
 * @param groupID in NSString format
 * @return NSString groupName 群組名稱
 */
- (NSString *)groupNameWithID:(NSString *)groupID;


/**
 * 依輸入的groupIDArray，取得多個群組model
 * @param groupIDArray array of groupID in NSString format
 * @return  array of WCGroupModel (release after using)
 */
- (NSArray *)groupModelsWithIDArray:(NSArray *)groupIDArray;

/**
 * 取得多個群組名稱
 * @param groupIDArray array of groupID in NSString format
 * @return NSStirng 以逗號分隔的群組字串
 */
- (NSString *)groupNamesWithIDArray:(NSArray *)groupIDArray;


@optional

// 新增群組, convert專用
// return : WCGroupModel (release after using)
- (BOOL)newGroupWithGroupModel:(WCGroupModel *)groupModel checkExist:(BOOL)checkExist;

/**
 * 取得類別順序修改時間
 * @return NSDate  類別順序修改時間
 */
- (NSDate *)groupOrderModifiedTime;

/**
 * 設定類別順序修改時間
 * @param groupOrderModifiedTime groupOrderModifiedTime
 */
- (void)setGroupOrderModifiedTime:(NSDate *)groupOrderModifiedTime;

/**
 * 清除類別順序修改時間
 */
- (void)removeGroupOrderModifiedTime;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card-Group methods

@protocol WCDataControllerProtocol_CardGroup <NSObject>

/**
 * 設定名片的群組
 *
 * @param cardID 目標名片的ID
 * @param groupIDArray 要設定的群組ID, groupIDArray不可為nil，若是未分類請加入WC_GID_Unfiled。
 * @return BOOL YES:成功。NO:失敗
 */
- (BOOL)setCardGroupsWithCardID:(NSString *)cardID groupIDArray:(NSArray *)groupIDArray;

/**
 * 取得名片所屬的所有群組ID
 * @param cardID cardID in NSString format
 * @return groupIDArray array of groupID in NSString format (release after using)
 */
- (NSMutableArray *)copyGroupIDArrayWithCardID:(NSString *)cardID;

@optional
/**
 * 取得群組中所有名卡ID (WCM，WCT看能不能用其他API取代)
 * @param groupID in NSString format
 * @return groupIDArray array of groupID in NSString format (release after using)
 */
- (NSMutableArray *)copyCardIDArrayWithGroupID:(NSString *)groupID;

/// 7.0 取得google 預設群組的聯絡人個數 (WCM)
- (NSInteger)cardCountForGoogleGroup;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card

@protocol WCDataControllerProtocol_Card <NSObject>

/// 取得名片總數
- (NSInteger)totalCardCount;

/// 檢查名片是否存在
- (BOOL)isCardIDExist:(NSString *)cardID;

/// 檢查是否為空名片，完全沒有名片資料與圖片
- (BOOL)isEmptyCardWithCardID:(NSString *)cardID frontSideImage:(CPImage *)frontSideImage backSideImage:(CPImage *)backSideImage;

/**
 * 取得lite用來匯出的名片所有資料 (姓名，公司，電話, 各一筆)
 * @param cardID 要取得的名片ID
 * @return  WCCardModel (release after using)
 */
- (WCCardModel *)copyLiteExportCardDataWithCardID:(NSString *)cardID;

/**
 * 取得名片所有資料 (display + field data)
 * @param cardID 要取得的名片ID
 * @return  WCCardModel (release after using)
 */
- (WCCardModel *)copyCardFullDataWithCardID:(NSString *)cardID;

/**
 * 取得名片顯示資料 (只有display)
 * @param cardID 要取得的名片ID
 * @return  WCCardModel (release after using)
 */
- (WCCardModel *)copyCardDisplayDataWithCardID:(NSString *)cardID;

/// 取得指定欄位資料
- (NSMutableArray *)copyFieldValueArrayWithCardIDArray:(NSArray *)cardIDArray fieldType:(WC_FieldType)fieldType;

/// 取得可播打的電話資料
- (NSMutableArray *)copyPhoneArrayWithCardIDArray:(NSArray *)cardIDArray;

/// 取得可傳送訊息的電話資料
- (NSMutableArray *)copyPhoneArrayForSendMessageWithCardIDArray:(NSArray *)cardIDArray;

/// 儲存名片（包含資料檢查）
- (BOOL)saveCard:(WCCardModel *)cardModel withFrontSideImage:(CPImage *)frontSideImage backSideImage:(CPImage *)backSideImage idPhotoImage:(CPImage *)idPhotoImage isImportMode:(BOOL)isImportMode sendNotification:(BOOL)sendNotification;

/// 儲存來自系統聯絡人的名片（包含資料檢查）
- (BOOL)saveWCABCard:(WCABCardModel *)abCardModel sendNotification:(BOOL)sendNotification;

/// 加入名片
- (BOOL)addCard:(WCCardModel *)cardModel withSendNotification:(BOOL)sendNotification;

/// 更新名片內容
- (BOOL)updateCard:(WCCardModel *)cardModel withSendNotification:(BOOL)sendNotification;

/// 刪除名片
- (BOOL)removeCards:(NSArray *)cardIDs;

/**
 * 更新名片的欄位來源
 * @param cardID 要更新的名片ID
 * @param fromFieldSource 原來的欄位來源
 * @param toFieldSource 要變更為什麼欄位來源
 * @param removeRecogRect 是否要清除辨識rect
 */
- (void)updateWithCardID:(NSString *)cardID fromFieldSource:(WC_FieldSource)fromFieldSource toFieldSource:(WC_FieldSource)toFieldSource removeRecogRect:(BOOL)removeRecogRect;

/// 調整欄位順序
- (void)updateOrderToFirstWithIndex:(NSInteger)index withCardID:(NSString *)cardID fieldType:(NSInteger)fieldType;

/// 取得note
- (NSString *)noteWithCardID:(NSString *)cardID;

/// 更新note
- (BOOL)updateNote:(NSString *)note withCardID:(NSString *)cardID;

@optional
/// 更新修改時間(display)
- (BOOL)updateCardModifiedTime:(NSDate *)modifiedTime withCardID:(NSString *)cardID;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCABCardModel

@protocol WCDataControllerProtocol_WCABCardModel <NSObject>

/// 以person ID查調是否有對應的cardID
- (NSString *)cardIDWithABPersonID:(NSString *)abPersonID;

/// 檢查person ID是否存在
- (BOOL)isCardExistWithABPersonID:(NSString *)abPersonID;;


/// 更新addressbook data, abCardModel.ID不能為nil
- (BOOL)updateAddressBookDataWithCardModel:(WCABCardModel *)abCardModel;

/// 刪除addressbook data
- (BOOL)removeAddressBookDataWithCardID:(NSString *)cardID;

/// 取得address book data , abCardModel.ID不能為nil
- (BOOL)getAddressBookDataWithCardModel:(WCABCardModel *)abCardModel;

/// 清除所有address book資料，還原時使用
- (BOOL)clearAddressBookData;

/// 取得所有address book資料，同步時使用
- (NSArray *)allAddressBookData;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - AddressBook convert to Contacts framework methods

@protocol WCDataControllerProtocol_AddressBookConvertToContacts <NSObject>

@optional
/**
 * 取得全部有AddressBook mapping的名片ID
 * @return card id array
 */
- (NSArray <NSString *>*)allCardIDFromAddressBookMapping;

/// 寫入新的mapping
- (BOOL)setAddressBookMappingWithCardID:(NSString *)cardID newSourceID:(NSString *)newSourceID newGroupID:(NSString *)newGroupID newPersonID:(NSString *)newPersonID;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - RecentContact

@protocol WCDataControllerProtocol_RecentContact <NSObject>

/// 加入最近連繫聯絡人
- (BOOL)insertRecentAction:(NSInteger)action withContent:(NSString *)content cardID:(NSString *)cardID;

/// 刪除最近聯繫聯僧人
- (BOOL)removeRecentActionWithCardID:(NSString *)cardID;

/// 取得所有最近聯繫聯絡人
- (NSMutableArray *)copyAllRecentCardSection;

/// 清除最近連繫聯絡人
- (BOOL)clearRecentContactData;

/// 是否有最近聯繫聯絡人
- (BOOL)hasRecentContacts;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Import (目前只有Cover時會用到，新的import已經不用這些api)

@protocol WCDataControllerProtocol_Import <NSObject>

@optional
/// 匯入開始
/// filterDuplicate : 是否要做重覆資料過濾動作
- (void)importCardBeginWithFilterDuplicate:(BOOL)filterDuplicate;

/// 匯入名片
/// return : NO 代表不需要設定名片圖
- (BOOL)importCard:(WCCardModel *)cardModel andUpdateCache:(BOOL)updateCache;

/// 匯入結束
- (void)importCardFinish;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Section

@protocol WCDataControllerProtocol_Section <NSObject>

/**
 * 取得section資料，完成時透過'WCDC_NOTIFY_LoadCardSectionsResult'通知。
 * （背景執行非同步模式，包含暫存機制）
 *
 * @param groupID groupID字串
 * @param searchText 搜尋字串，nil或空字串代表取得全部資料。
 * @param forceReload YES代表強制從資料庫重新讀取；NO會先檢查cache，沒有才從資料庫撈。
 * @return YES表示進行讀取，NO表示沒讀取。
 */
- (BOOL)loadCardSectionsWithGroupID:(NSString *)groupID searchText:(NSString *)searchText forceReload:(BOOL)forceReload;

/**
 * 取得section資料，完成時透過completion block通知。
 * （背景執行非同步模式，包含暫存機制）
 *
 * @param groupID groupID字串
 * @param searchText 搜尋字串，nil或空字串代表取得全部資料。
 * @param forceReload YES代表強制從資料庫重新讀取；NO會先檢查cache，沒有才從資料庫撈。
 * @param completion 回傳結果的block。如果是nil結果會透過'WCDC_NOTIFY_LoadCardSectionsResult'通知。
 * @return YES表示進行讀取，NO表示沒讀取。
 */
- (BOOL)loadCardSectionsWithGroupID:(NSString *)groupID searchText:(NSString *)searchText forceReload:(BOOL)forceReload completion:(LoadCardSectionCompletion)completion;

/**
 取得section資料

 @param groupID groupID字串
 @param searchText 搜尋字串，nil或空字串代表取得全部資料。
 @return array of WCCardSectionModel
 */
- (NSMutableArray *)copyCardSectionsWithGroupID:(NSString *)groupID searchText:(NSString *)searchText;

/**
 取消loadCardSections動作
 */
- (void)cancelLoadCardSections;

@optional

/// 將Section array轉換為WCCardStreamModel，供flow/thumb顯示模式使用。
- (WCCardStreamModel *)copyCardStreamFromCardSectionArray:(NSMutableArray *)cardSectionArray;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - DisplayRule

@protocol WCDataControllerProtocol_DisplayRule  <NSObject>

@optional

/// 建立顯示需要的額外資料 (通常在建立新的名片後使用)
- (void)makeCardsDisplayData:(NSArray *)cardArray displayRule:(WCSC_DisplyRule)displayRule __attribute__((deprecated("改用 makeCardsStoreData")));

/// 建立顯示需要的額外資料 (通常在建立新的名片後使用)
- (void)makeCardsStoreData:(NSArray *)cardArray;

/// 將資料庫中所有資料，依displayRule變更顯示規則
- (BOOL)applyDisplayRuleChangeWithSendNotification:(BOOL)sendNotification;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Duplicate

@protocol WCDataControllerProtocol_Duplicate <NSObject>


/**
 * 合併聯絡人
 * @param cardIDs 要合併的聯絡人ID列表，要用來合併的base card要放在第一筆
 * manualMode: 多選合併時使用，主要不同是在都只有正面時，manualMode==YES，會把一個當正面一筆當反面
 */
- (void)mergeWithCardIDs:(NSArray *)cardIDs manualMode:(BOOL)manualMode;

@optional

/**
 * 取得重覆資料 , WCT用copyDuplicateCardSectionModelsWithOwnerID
 * @return array of WCCardSectionModel
 *      returnArray -> cardSectionModel.cardArray -> cardModel
 *                                                   cardModel
 *                                                   ...
 *                     cardSectionModel.cardArray -> cardModel
 *                                                   cardModel
 *                                                   ...
 */
- (NSMutableArray *)copyDuplicateCardSectionModelsWithOwnerID:(NSString *)ownerID compareNameOnly:(BOOL)compareNameOnly;


@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Unrecognized

@protocol WCDataControllerProtocol_Unrecognized <NSObject>

// 加入未辨識影像
- (BOOL)addUnrecognizedImage:(CPImage *)image;

// 刪除未辨識影像
- (BOOL)removeUnrecognizedImageWithID:(NSString *)unrecognizedID;

// 取得所有未辨識影像ID
- (NSArray *)unrecognizedIDArray;

// 取得未辨識影像
- (CPImage *)copyUnrecognizedImageWithID:(NSString *)unrecognizedID imageSubType:(WC_ImageSubType)imageSubType;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Reminder

@protocol WCDataControllerProtocol_Reminder <NSObject>

// 因為WCT沒有，所以全部都設為optional, 但WCM都要實作
@optional

/// 建立WCReminder table, 資料庫升級使用
- (BOOL)createReminder;

/// 計算某天有幾個新提醒
- (NSInteger)reminderCountWithDate:(NSDate*)date;

/// 補上到今天前應有的提醒
- (void)generateReminderWithDate;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Utiliey

@protocol WCDataControllerProtocol_Utility <NSObject>
/// 壓縮資料庫(需配合WCCardDBController的實作)
- (void)compactData;


@optional

/// 設定資料庫版本資訊
- (void)setDBVersionInfo:(NSString *)versionInfo;


/// 重新連線資料庫
- (void)reconect;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Notify

@protocol WCDataControllerProtocol_Notify <NSObject>


//===============================================================================
//WCM 6.2.0以後新增，通知名片資料已更新
//===============================================================================
- (void)notifyDataChanged:(NSString *)notifyName infoKey:(NSString *)infoKey infoValue:(id)infoValue;

//===============================================================================
// WCSF 1.0新增，通知名片已更新，自訂userInfo
//===============================================================================
- (void)notifyDataChanged:(NSString *)notifyName userInfo:(NSDictionary *)userInfo;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - For WCM Sync use

@protocol WCDataControllerProtocol_WCMSync <NSObject>

@optional
#pragma mark - (Sync) fast sync record


//===============================================================================
//取得同步要用的已刪除groupID
//===============================================================================
- (NSMutableArray *)copyDeleteGroupIDArrayForFastSyncAfterDate:(NSDate *)date syncTarget:(WCSyncTarget)syncTarget;


//===============================================================================
// 清除快速同步用 table的資料
//===============================================================================
- (BOOL)removeDeleteGroupIDFromFastSyncBeforeDate:(NSDate *)date syncTarget:(WCSyncTarget)syncTarget;


//===============================================================================
//取得同步要用的已刪除CardID
//===============================================================================
- (NSMutableArray *)copyDeleteCardIDArrayForFastSyncAfterDate:(NSDate *)date syncTarget:(WCSyncTarget)syncTarget;


//===============================================================================
// 清除快速同步用table的資料
//===============================================================================
- (BOOL)removeDeleteCardIDFromFastSyncBeforeDate:(NSDate *)date syncTarget:(WCSyncTarget)syncTarget;


//===============================================================================
//WCM 6.2.0 新增 取得名片刪除時間
//===============================================================================
- (NSDate *)cardDeletedTimeWithCardID:(NSString *)cardID syncTarget:(WCSyncTarget)syncTarget;


#pragma mark - (Sync) extended property

/**
 * 將google 同步時的extendedProperty記錄下來
 *
 * @param extendedPropertyString extendedProperty轉換後的string，如果是nil會刪除此筆資料
 * @param cardID 要設定的名片ID, 不能是nil
 * @return BOOL  YES:成功, NO:失敗
 */
- (BOOL)setExtendedPropertyString:(NSString *)extendedPropertyString forCardID:(NSString *)cardID;

/**
 * 取得名片的extendedProperty
 * @param cardID 名片ID, 不能是nil
 * @return NSString 該名片的extendedProperty
 */
- (NSString *)extendedPropertyStringForCardID:(NSString*)cardID;

/**
 * 清除extendedPropertyForSync的所有資料
 * @return BOOL  YES:成功, NO:失敗
 */
- (BOOL)clearExtendedPropertyForSync;

#pragma mark - (Sync) error list

/// 取得所有同步失敗的名片，回傳 array of WCSyncErrorCardModel
- (NSArray *)copyAllSyncErrorCardWithDisplayData;

/// 取得所有同步失敗的CardIDArray
- (NSArray *)copySyncErrorCardIDArray;

/// 設定同步失敗的errorCode
- (BOOL)updateCardSyncErrorInfoWithCardID:(NSString *)cardID errorCode:(NSInteger)errorCode startSyncTime:(NSDate *)startSyncTime;

/// 清除同步失敗記錄
- (BOOL)removeCardSyncErrorInfoWithCardID:(NSString *)cardID;

#pragma mark - (Sync) image

/// 取得影像的identifier
- (NSMutableDictionary *)imageIdentifierDictWithCardID:(NSString *)cardID;

/// 儲存影像的identifier, 會寫入到資料庫 (For Sync)
- (BOOL)setImageIdentifierDict:(NSMutableDictionary *)imageIdentifierDict withCardID:(NSString *)cardID;

/// 清除所有影像的identifier
- (BOOL)clearImageIdentifierDictForSync;

/// 儲存影像到暫存檔 (Sync)
- (BOOL)saveCardImageDataToTempFile:(NSData *)imageData withImageType:(WC_ImageType)imageType;

/// 把影像暫存檔改為正式cardID (Sync)
- (void)applyCardImageTempFileToCardID:(NSString *)cardID withImageType:(WC_ImageType)imageType;

/// 刪除所有暫存檔 (Sync)
- (void)cleanAllCardImageTempFile;


#pragma mark - (Sync) group

/// 取得群組最後編輯時間 (Sync)
- (NSDate *)groupModifiedTimeWithID:(NSInteger)groupID;

/// 新增群組 (Sync)
/// return : WCGroupModel (release after using)
- (WCGroupModel *)newGroupWithNameForSync:(NSString *)groupName;


#pragma mark - (Sync) card

/// 取得空資料名片，包含沒有圖片的也算在內 (For Sync)
- (NSArray *)copyEmptyCardID;

/// 取得名片最後編輯時間 (For Sync)
- (NSDate *)cardModifiedTimeWithCardID:(NSString *)cardID;

/// 同步，更新時的刪除名片動作 (For Sync)
- (BOOL)removeCardDataForSyncUpdate:(NSString *)cardID;

/// 同步，刪除時的刪除名片動作 (For Sync)
- (BOOL)removeCards:(NSArray *)cardIDArray needAddFastSyncTable:(BOOL)needAddFastSyncTable;


#pragma mark - (Sync) utility

/// 取消目前動作 (For Sync), 同步的動作cancel時呼叫，用來取消當下動作 (需配合WCCardDBController的實作)
- (void)cancel;

/// 重設取消的flag
- (void)clearCancelFlag;

#pragma mark - (Sync) fix DB
// v7.1 修正有非法字元的讀音 (For Sync)
- (void)fixInvalidPhonetic;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - For overriding
@protocol WCDataControllerOverrideProtocol
@optional
- (void)setCardDBController:(id)cardDBController;
- (BOOL)loadCardDBController;

@end

