//
//  WCCoverFlowActionBar.h
//  Pods
//
//  Created by sanhue on 2016/7/1.
//
//

#import "PPBarView.h"

@class WCCoverFlowActionBar;

@protocol WCCoverFlowActionBarDelegate <NSObject>
- (NSString *)contentStringAtIndex:(NSInteger)index withAction:(NSInteger)action;

@optional

/**
 * 按下go時通知app要執行動作
 * @param actionBar instance of bar
 * @param action current actoin of bar
 * @param content content of current bar
 */
- (void)actionBar:(WCCoverFlowActionBar *)actionBar didClickAction:(NSInteger)action withContent:(NSString *)content index:(NSInteger)index;


/**
 * 是否能開啟內容選單
 * @param action current actoin of bar
 * @return BOOL 可以再開啟
 */
- (BOOL)shouldOpenContentBarWithAction:(NSInteger)action;

/**
 * 是否能再做上一頁
 * @param action current actoin of bar
 * @param index current index
 * @return BOOL 可以再往前
 */
- (BOOL)hasPrevWithAction:(NSInteger)action index:(NSInteger)index;


/**
 * 是否能再做下一頁
 * @param action current actoin of bar
 * @param index current index
 * @return BOOL 可以再往前
 */
- (BOOL)hasNextWithAction:(NSInteger)action index:(NSInteger)index;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCCoverFlowBarAction)
{
    WCCoverFlowBarAction_None  = 0,
    WCCoverFlowBarAction_Tel,
    WCCoverFlowBarAction_Mail,
    WCCoverFlowBarAction_Map,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCCoverFlowActionBar : PPBarView
@property (nonatomic, assign) id<WCCoverFlowActionBarDelegate> delegate;

#pragma mark style

/// 呈顯content bar時的背景色，預設 whiteColor
@property (nonatomic, retain) UIColor *contentBarBackgroundColor;

/// content bar裡的按鈕的寬度, default 0，表示使用bar的高度
@property (nonatomic, assign) CGFloat contentBarButtonWidth;

/// content bar裡的按鈕的edgeInsets, default UIEdgeInsetsZero
@property (nonatomic, assign) UIEdgeInsets contentBarButtonEdgeInsets;

/// ActionBar裡的按鈕的edgeInsets, default UIEdgeInsetsZero
@property (nonatomic, assign) UIEdgeInsets actionBarButtonEdgeInsets;

/// content bar中的title label的最大字型，default 20
@property (nonatomic, assign) CGFloat maxTitleFontSize;

/// content bar中的title label的最小字型，default 16, maxTitleFontSize最好不要差太多，不然切換時會不好看
@property (nonatomic, assign) CGFloat minTitleFontSize;

#pragma mark public methods

/// 關閉content bar
- (void)hideContentBar;

@end
