//
//  ContactEditFieldAddedCellDataModel.h
//
//  Created by Howard.Lin on 13/10/2.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "ContactEditFieldDataModel.h"

@interface ContactEditFieldAddedCellDataModel : ContactEditFieldDataModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 * To return title array is based on contactMainType and subType
 * @param contactMainType The section you want to select
 * @param contactModelSubTypeArray The row you want to select
 * @return: The title array is based on contactMainType and subType
 */
+ (NSMutableArray *)customTitleArrayForPPContactMainType:(PPContactMainType)contactMainType
                              ppContactModelSubTypeArray:(NSArray *)contactModelSubTypeArray;


/**
 * To return placeholder array is based on contactMainType
 * @param contactMainType The section you want to select
 * @return: The placeholder array is based on contactMainType
 */
+ (NSMutableArray *)defaultTitleArrayForPPContactMainType:(PPContactMainType)contactMainType;


/**
 * To return PPContactSectionModel is based on contactMainType
 * @param contactMainType The section you want to select
 * @return: The PPContactSectionModel is based on contactMainType;
 */
+ (PPContactSectionModel *)ppContactSectionModelForPPContactMainType:(PPContactMainType)contactMainType;

@end
