//
//  WCMCardListCell_V5.h
//  WorldCardMobile
//
//

#import <UIKit/UIKit.h>
#import "WCFieldDefine.h"
#import "PPButton+Factory.h"

extern const NSInteger WCCardHolderCellCustomTag;

typedef NS_ENUM(NSInteger, WCCardHolderCellType)
{
    WCCardHolderCellType_None = 0,          // 預設
    WCCardHolderCellType_Normal,            // 顯示名片圖，且有未校正圖示
    WCCardHolderCellType_ActionType,        // 顯示名片圖，AdditionButton (ContactActionType)
    WCCardHolderCellType_Distance,          // 顯示名片圖，AdditionButton(Info), AdditionLabel(Distance)
    WCCardHolderCellType_Duplicate ,          // 顯示名片圖與WCCardHolderCellType_Normal一樣
    WCCardHolderCellType_DuplicateWithOwner, // 顯示名片圖，AdditionLabel(Owner)
    WCCardHolderCellType_CompanyContacts,          // AdditionButton
    WCCardHolderCellType_CompanyContactsWithOwner, // AdditionButton(Download), AdditionLabel (Owner)
    WCCardHolderCellType_OnlyDisplayData,          // 只有displyaName, displayCompany, displayJobTitle
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCCardHolderCell;

@protocol WCCardHolderCellDelegate <NSObject>
/**
 * 回傳縮圖給cell，用來顯示
 */
- (UIImage *)copyCardListCellThumbImage:(WCCardHolderCell *)cell;

@optional
/// cellType==WCCardHolderCellType_ActionType才會進來，按鈕按下時回傳
/**
 * cellType==WCCardHolderCellType_ActionType時按下additionButton回傳
 * @param cell 目前點擊到的cell
 * @param actionType 目前action是什麼
 */
- (void)wcCardHolderCell:(WCCardHolderCell *)cell didClickActionButtonWithType:(ContactActionType)actionType;

/// cellType==WCCardHolderCellType_ActionType時才會進來，長按時回傳
- (void)wcCardHodlerCellDidLongPressActionButton:(WCCardHolderCell *)cell;

/// enableLongPress 時才會進來，長按cell時回傳
- (void)wcCardHodlerCellDidLongPress:(WCCardHolderCell *)cell;

/// cellType!=WCCardHolderCellType_ActionType時按下additionButton回傳
- (void)didClickAdditionButtonWithCell:(WCCardHolderCell *)cell;


/// selectMode==YES時，按下check時才會進來，按鈕按下時回傳
- (void)didClickCheckButtonWithCell:(WCCardHolderCell *)cell;


@end

// layout 關係圖解
// Name，Company，JobTitle為固定存在的項目
// 其他區塊則看設定決定是否顯示
// ---------------------------------------------------------------------
// |			|				|Name					|additionLabel	|
// |selectMode	|showCardImage	|Company				|additionButton	|
// |			|				|Job title				|				|
// ---------------------------------------------------------------------


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCCardHolderCell : UITableViewCell <PPButtonDelegate>

/// WCCardHolderCellDelegate
@property (nonatomic, assign) id<WCCardHolderCellDelegate> delegate;

/// 此cell對應的cardID
@property (nonatomic, retain) NSString *cardID;


#pragma mark - cell ui property
/// 名片圖
@property (nonatomic, retain, readonly) UIImageView *cardImageView;

/// 姓名label
@property (nonatomic, retain, readonly) UILabel *nameLabel;

/// 公司label
@property (nonatomic, retain, readonly) UILabel *companyLabel;

/// 職稱label
@property (nonatomic, retain, readonly) UILabel *jobTitleLabel;

/// 右上方的label
@property (nonatomic, retain, readonly) UILabel *additionLabel;

/// 右下的button
@property (nonatomic, retain, readonly) PPButton *additionButton;

/// 設定背景圖
@property (nonatomic, retain) UIImage *normalBgImage;

/// 設定選取時的背景圖
@property (nonatomic, retain) UIImage *highlightBgImage;


#pragma mark - cell style setting

/// 設定是否為選取模式 (會有勾選按鈕)
@property (nonatomic, assign) BOOL selectMode;

/// 快速設定cell style, 內容包含 showCardImage, showAdditionLabal, showAdditionButton的集合設定
@property (nonatomic, assign) WCCardHolderCellType cellType;

/// 設定是否顯示名片圖
@property (nonatomic, assign) BOOL showCardImage;

///  設定是否顯示右上方的label, (會與nameLabel共享寬度)
@property (nonatomic, assign) BOOL showAdditionLabal;

/// 設定是否顯示右方按鈕 (與additionLabel共享高度)
@property (nonatomic, assign) BOOL showAdditionButton;


#pragma mark - cell ui value

/// 設定是否為已校正
@property (nonatomic, assign) BOOL verified;

/// 如果selectMode==YES, 把checkbox勾選起來
@property (nonatomic, assign) BOOL checked;

/// 如果cellType設為WCCardHolderCellType_ActionType, 設定addtionButton的按鈕圖示
@property (nonatomic, assign) ContactActionType currentActionType;

/// cell下方保留高度，custom cell時用, default 0
@property (nonatomic, assign) NSInteger bottomReserveHeight;

#pragma mark - cell function setting
/// 是否開啟cell的長按功能，default NO
@property (nonatomic, assign) BOOL enableLongPress;


#pragma mark - Instance methods

/// 初始化cell
- (id)initWithDelegate:(id)delegate
       reuseIdentifier:(NSString *)identifier;


/// 通知cell開始load圖
- (void)startLoadCardImage;

#pragma mark - For subclass
- (void)resetLayoutConstraints;
- (void)removeLayoutConstraints;


#pragma mark - Class methods
+ (void)tellThreadTernimate;
+ (void)tellThreadDecelerating:(BOOL)isDecelerating;

/// 根據action type 回傳icon 檔名
+ (NSString *)imageNameWithActionType:(ContactActionType)actionType;

/// 根據action type 回傳icon
+ (UIImage *)imageWithActionType:(ContactActionType)actionType;

@end
