//
//  WCCaptureFlowController.h
//
//
//  Created by Howard on 2016/1/12.
//
//

#import <Foundation/Foundation.h>

// Define
#import "WCCaptureFlowControllerDatasource.h"
#import "WCCaptureFlowControllerDelegate.h"
#import "WCCaptureFlowController+ParameterDefine.h"

// Controller
#import "WCCaptureViewController.h"

@interface WCCaptureFlowController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<WCCaptureFlowControllerDatasource> captureFlowDatasource;
@property (nonatomic,assign) id<WCCaptureFlowControllerDelegate> captureFlowDelegate;
@property (nonatomic,assign) NSInteger maxCaptureCardCount; // -1 代表無上限
@property (nonatomic,assign) CGSize defaultCapturedImageSize; //圖片大小
@property (nonatomic,assign) NSUInteger curCaptureCardCount;
@property (nonatomic,assign) BOOL hideNextCardButton;

/// 到達上限的alert是否顯示"馬上訂閱"
@property (nonatomic,assign) BOOL showSubscribeWhenReachMaxCount;

/// 隱藏拍照數量，default NO;
@property (nonatomic,assign) BOOL hideCaptureCount;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  新增圖片(基座,手動,QRCode)
 *
 *  @param viewController      來源視圖
 *  @param captureSide         正反面
 *  @param captureCount        數量
 *  @param supportCaptureModes 模式(基座,手動,QRCode)
 *  @param activeCaptureMode   目前模式
 *  @param presentCompletion   callBack
 */
- (void)presentMultiModeFromViewController:(UIViewController *)viewController
                               captureSide:(WCCaptureViewController_CaptureSide)captureSide
                              captureCount:(NSInteger)captureCount
                       supportCaptureModes:(NSArray *)supportCaptureModes
                         activeCaptureMode:(WCCaptureViewController_CaptureMode)activeCaptureMode
                         presentCompletion:(void (^)(BOOL success))presentCompletion;

/**
 *  手動新增圖片
 *
 *  @param viewController    來源視圖
 *  @param captureSide       正反面
 *  @param presentCompletion callBack
 */
- (void)presentSingleManualModeFromViewController:(UIViewController *)viewController
                                      captureSide:(WCCaptureViewController_CaptureSide)captureSide
                                presentCompletion:(void (^)(BOOL success))presentCompletion;
@end
