//
//  BRFCMainViewController.h
//
//

#import "PPTableViewController.h"
#import "PPStorageSpaceSelectViewController+PublicParameterDefine.h"
#import "WCBackupRestoreFlowController+TypeDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef void (^BRFCCompleteBlock)(WCBackupRestoreFlowController_Action action, NSError *error);
typedef BOOL (^BRFCHandleDataBlock)(NSString *);

////////////////////////////////////////////////////////////////////////////////////////////////////

@class BRFCMainViewController;
@protocol BRFCMainViewControllerDelegate <NSObject>

- (void)mainViewControllerRequestBackupInfo:(BRFCMainViewController *)mainViewController;
- (void)mainViewControllerRequestSapceInfo:(BRFCMainViewController *)mainViewController;
- (void)mainViewControllerDidClickBackup:(BRFCMainViewController *)mainViewController;
- (void)mainViewControllerDidClickRestore:(BRFCMainViewController *)mainViewController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface BRFCMainViewController : PPTableViewController

- (instancetype)initWithDelegate:(id<BRFCMainViewControllerDelegate>)delegate
                       spaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType;

- (void)hideSpaceInfo;
- (void)updateBackupInfo:(NSString *)backupInfo;
- (void)updateSpaceInfoWithTotalBytesText:(NSString *)totalBytesText freeBytesText:(NSString *)freeBytesText;

@end
