//
//  WCAdvancedSearchViewController.h
//  ADAL
//
//  Created by sanhue on 2018/10/22.
//

#import <Foundation/Foundation.h>
#import "PPViewController.h"

//define
#import "WCAdvancedSearchViewController+ParameterDefine.h"
#import "WCAdvancedSearchViewController+ResourceDefine.h"

// Model
#import "WCGroupModel.h"
#import "WCCustomFieldInfo.h"
#import "WCAdvancedSearchModel.h"
#import "PPSectionController.h"

// View
#import "AdvanceSearchView.h"

NS_ASSUME_NONNULL_BEGIN


typedef void(^WCAdvancedSearchSelectItemCompletion)(PPSectionModel *selectedSectionModel, PPRowModel *selectedRowModel);

typedef void(^WCAdvancedSearchOperatorCompletion)(NSUInteger itemIndex, NSString *itemString);

////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCAdvancedSearchViewController;
@protocol WCAdvancedSearchViewControllerDelegate <NSObject>

//點選搜尋按鈕，Options已經濾掉添加
- (void)advancedSearchViewController:(WCAdvancedSearchViewController *)advancedSearchViewController endWithAdvancedSearchModel:(WCAdvancedSearchModel* )advancedSearchModel;

// 要求外部提供目前的群組清單
- (NSMutableArray<WCGroupModel *> *)requestGroupListInAdvancedSearchViewController:(WCAdvancedSearchViewController *)advancedSearchViewController;

// 要求外部回傳已選擇的群組Path
- (NSString *)advancedSearchViewController:(WCAdvancedSearchViewController *)advancedSearchViewController groupPathSelectedWithGroupIDArray:(NSArray *)groupIDArray;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTAdvancedSearchViewController Interface

@interface WCAdvancedSearchViewController : PPViewController
<
AdvanceSearchViewDelegate,
AdvanceSearchViewDataSource
>

////////////////////////////////////////////////////////////////////////////////////////////////////

/// 繼承時使用這圈指定advancedSearchModel的class
- (instancetype)initWithModelClass:(Class)modelClass;

#pragma mark - 客制化(繼承)時才需要使用
@property (nonatomic, retain, nullable) NSIndexPath *currentSelectIndexPath;
/// 設定進階搜尋的條件 (WCAdvancedSearchViewController_OptionCategory)，預設有Contact info, Group, Date
@property (nonatomic, retain, readonly, nullable) NSMutableArray *currentOptionCategoryArray;

#pragma mark - Property

@property (nonatomic, assign)   id<WCAdvancedSearchViewControllerDelegate> delegate;
@property (nonatomic, readonly) WCAdvancedSearchModel *currentAdvancedSearchModel; //!! 會包含非OptionModel
@property (nonatomic, readonly) AdvanceSearchView *advanceSearchView;

// 是否顯示類別, 預設YES
@property (nonatomic, assign)   BOOL isContainCategory;


//初始化與初始條件設定
- (void)loadAdvancedSearchModel:(WCAdvancedSearchModel *)advancedSearchModel;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Utilities

/// 依optionCategory，取得目前使用的condition array
- (NSMutableArray *)conditionsWithOptionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory;

/// 取得欄位字串
- (NSString *__nullable)fieldTypeStringFromType:(WCSearchType)searchType;

/// 是否為新增欄位
- (BOOL)isAddSearchOptionAtIndexPath:(NSIndexPath *)indexPath;

/// 在array中加入 "新增欄位"的item
- (BOOL)addSearchOptionIfNeedWithArray:(NSMutableArray *)categoryArray;

/**
 * 清除條件中的 "新增"，並檢查內容是否有錯
 * 有客制的條件要orerride這個，加入客制條件的處理
 * @param errorFieldTitle 回傳沒有值的欄位
 * @return WCAdvancedSearchModel 回傳沒有包含 "新增"的條件
 */
- (WCAdvancedSearchModel *)correctAdvnacedSearchModelWithReturnedErrorFieldTitle:(NSString *__nullable *__nullable)errorFieldTitle;

/**
 * 顯示清單介面
 * @param title 清單title
 * @param indexPath 所在cell的indexPath
 * @param sectionModel 清單項目
 * @param completeHandler 回傳選取結果
 */
- (void)showSelectItemViewControllerWithTitle:(NSString *)title
                                    indexPath:(NSIndexPath*)indexPath
                                 sectionModel:(PPSectionModel *)sectionModel
                              completeHandler:(WCAdvancedSearchSelectItemCompletion)completeHandler;
/**
 * 顯示交集聯集選擇介面
 * @param indexPath 所在cell的indexPath
 * @param completeHandler 回傳選取結果
 */

- (void)showOperatorSelectionWithIndexPath:(NSIndexPath *)indexPath
                           completeHandler:(WCAdvancedSearchOperatorCompletion)completeHandler;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 介面操作

/// 用在多cell, 如聯絡資訊，自訂欄位
- (void)insertCellWithOptionModel:(WCSearchOptionModel*)optionModel optionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory;

/// 用在單一cell的更新，如 類別，時間，帳號
- (void)updateCellWithOptionModel:(WCSearchOptionModel*)optionModel optionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory;

/// 刪除cell
- (void)removeCellAtIndexPath:(NSIndexPath *)indexPath;

@end


NS_ASSUME_NONNULL_END
