//
//  PPViewController.h
//  
//
//  Created by Mike on 13/5/7.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "UIViewController+Additions.h"
#import "PPInterfaceOrientationController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPViewController : UIViewController 
{
@private
    BOOL                                shouldLayoutSubviews_;
    UIImageView                         *backgroundImageView_;
	UIPopoverController                 *masterViewPopoverController_;
    PPInterfaceOrientationController    *ppInterfaceOrientationController_;
    UIColor                             *navigationBarBackgroundColor_;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Property

@property(nonatomic,readonly,retain)    UIImageView                         *backgroundImageView;
@property(nonatomic,retain)             UIPopoverController                 *masterViewPopoverController;
@property(nonatomic,readonly)           PPInterfaceOrientationController    *ppInterfaceOrientationController;
@property(nonatomic,assign)             BOOL                                preferedStatusBarHidden;
@property(nonatomic,retain)             UIColor                             *navigationBarBackgroundColor;
@property(nonatomic,assign)             BOOL                                isViewDidAppear;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Intended For Subclasses Method

/**
 * Subclasses should layout subviews in this method
 */
- (void)layoutSubviews;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

/**
 Tell if view is visible

 @return YES if visible
 */
- (BOOL)viewIsVisible;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

/**
 * Set default view background color
 */
+ (void)setDefaultBackgroundColor:(UIColor *)color;

/**
 * Set default navigationBar background color
 */
+ (void)setDefaultNavigationBarBackgroundColor:(UIColor *)color;


/**
 * Set preferred status bar style
 * info.plist要加入 UIViewControllerBasedStatusBarAppearance 設定為YES才有用
 */
+ (void)setDefaultStatusBarStyle:(UIStatusBarStyle)style;


/**
 * 設定隱藏navigtionbar background image 及shadow image
 */
+ (void)setNavigationBarBackgroundImageHidden:(BOOL)hidden;


/**
 * 設定modal presentation style
 */
+ (void)setDefaultModalPresentationStyle:(UIModalPresentationStyle)style;
@end
