//
//  PPPhoneTextFieldTableViewCell.h
//
//  Created by Howard.Lin on 13/10/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCell.h"
#import "CustomRectTextField.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPPhoneTextFieldTableViewCell;
@protocol PPPhoneTextFieldTableViewCellDelegate <NSObject>
@optional

/**
 * Asks the delegate if editing should begin in the specified text field
 * @param phoneTextFieldTableViewCell The textfield of phoneTextFieldTableViewCell for which an editing session should began
 * @return: If return YES, the text field should be begin editing
 */
- (BOOL)ppPhoneTextFieldTableViewCellShouldBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell;


/**
 * To ask the keyboard if show or hide
 * @param phoneTextFieldTableViewCell The cell has keyboard foucs
 * @return: Return YES if hide
 */
- (BOOL)ppPhoneTextFieldTableViewCellShouldReturn:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell;


/**
 * To notify the cell is to edit initially
 * @param phoneTextFieldTableViewCell The cell prepares to edit
 */
- (void)ppPhoneTextFieldTableViewCellDidBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell;


/**
 * To notify the cell text is changed
 * @param phoneTextFieldTableViewCell The cell is typing words
 */
- (void)ppPhoneTextFieldTableViewCellDidChanged:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell;


- (BOOL)ppPhoneTextFieldTableViewCellShouldEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell;
- (void)ppPhoneTextFieldTableViewCellDidEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPPhoneTextFieldTableViewCell : PPTableViewCell <UITextFieldDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)     id<PPPhoneTextFieldTableViewCellDelegate> delegate;
@property(nonatomic,readonly)   CustomRectTextField *textField;
@property(nonatomic,assign)     NSUInteger                                maxLength;
@property(nonatomic,copy)       NSString                                  *countryCode;
@property(nonatomic,assign)     BOOL                                      autoFormat;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

/**
 * To ask if editing should begin in the specified text field
 * @return: If return YES, the text field should be begin editing
 */
- (BOOL)textFieldShouldBeginEditing;


/**
 * The textfield's keyboard is show or hide
 * @return: If return YES, the keyboard is hide
 */
- (BOOL)textFieldShouldReturn;


/**
 * The textfield is to edit
 */
- (void)textFieldDidBeginEditing;


/**
 * The textfield's text is changed
 */
- (void)textFieldTextDidChange;


@end
