//
//  PPLabelTableViewCell.h
//
//  Created by Howard.Lin on 13/10/17.
//  Modified by Andrew.Lai on 14/08/20.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCell.h"
#import "CustomRectLabel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

extern CGFloat PPLabelTableViewCell_ShortPressDuration;

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPLabelTableViewCell;
@protocol PPLabelTableViewCellDelegate <NSObject>

@optional
- (void)ppLabelTableViewCellDidShortPress:(PPLabelTableViewCell *)labelTableViewCell;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPLabelTableViewCell : PPTableViewCell
{
  @protected
    id<PPLabelTableViewCellDelegate> delegate_;
    CustomRectLabel                  *valueTextLabel_;
    UILongPressGestureRecognizer     *shortPressGestureRecognizer_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)   id<PPLabelTableViewCellDelegate> delegate;
@property(nonatomic,readonly) CustomRectLabel                  *valueTextLabel;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To add LognPressGesutreRegocnizer
 */
- (void)addShortPressGestureRecognizer;


/**
 * To remove LognPressGesutreRegocnizer
 */
- (void)removeShortPressGestureRecognizer;


@end
